/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;

public class GetAIFCommand
extends AbstractDebugCommand {
    private String varName = "";

    public GetAIFCommand(BitList tasks, String varName) {
        super(tasks);
        this.varName = varName;
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        this.checkBeforeExecCommand(debugger);
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.getAIF(this.tasks, this.varName);
    }

    public IAIF getAIF() throws PCDIException {
        try {
            Object res = this.getResultValue();
            if (res instanceof IAIF) {
                return (IAIF)res;
            }
            throw new PCDIException("Unknown aif: " + res);
        }
        catch (PCDIException pCDIException) {
            return AIFFactory.UNKNOWNAIF();
        }
    }

    public String getCommandName() {
        return "Get AIF: " + this.varName;
    }
}

