/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.commands;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.aif.IAIF;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.commands.AbstractDebugCommand;
import org.eclipse.ptp.debug.external.core.proxy.event.ProxyDebugPartialAIFEvent;

public class GetPartialAIFCommand
extends AbstractDebugCommand {
    private String name = "";
    private String key = "";
    private boolean listChildren = false;
    private boolean express = false;

    public GetPartialAIFCommand(BitList tasks, String name, String key, boolean listChildren, boolean express) {
        super(tasks);
        this.name = name;
        this.key = key;
        this.listChildren = listChildren;
        this.express = express;
    }

    public GetPartialAIFCommand(BitList tasks, String name, String key, boolean listChildren) {
        this(tasks, name, key, listChildren, false);
    }

    public GetPartialAIFCommand(BitList tasks, String name, String key) {
        this(tasks, name, key, false, false);
    }

    public void preExecCommand(IAbstractDebugger debugger) throws PCDIException {
        this.checkBeforeExecCommand(debugger);
    }

    public void exec(IAbstractDebugger debugger) throws PCDIException {
        debugger.getPartialAIF(this.tasks, this.name, this.key, this.listChildren, this.express);
    }

    public IAIF getPartialAIF() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof ProxyDebugPartialAIFEvent) {
            return ((ProxyDebugPartialAIFEvent)res).getData();
        }
        throw new PCDIException("No aif found.");
    }

    public String getName() throws PCDIException {
        Object res = this.getResultValue();
        if (res instanceof ProxyDebugPartialAIFEvent) {
            return ((ProxyDebugPartialAIFEvent)res).getName();
        }
        throw new PCDIException("No aif found.");
    }

    public String getCommandName() {
        return "Get Partial AIF: " + this.name;
    }
}

