/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class MakeContentProvider
implements ITreeContentProvider,
IMakeTargetListener,
IResourceChangeListener {
    protected boolean bFlatten;
    protected StructuredViewer viewer;

    public MakeContentProvider() {
        this(false);
    }

    public MakeContentProvider(boolean flat) {
        this.bFlatten = flat;
    }

    public Object[] getChildren(Object obj) {
        block8: {
            if (obj instanceof IWorkspaceRoot) {
                try {
                    return MakeCorePlugin.getDefault().getTargetManager().getTargetBuilderProjects();
                }
                catch (CoreException coreException) {
                    break block8;
                }
            }
            if (obj instanceof IContainer) {
                ArrayList<Object> children = new ArrayList<Object>();
                try {
                    IResource[] resource = ((IContainer)obj).members();
                    int i = 0;
                    while (i < resource.length) {
                        if (resource[i] instanceof IContainer) {
                            children.add(resource[i]);
                        }
                        ++i;
                    }
                    children.addAll(Arrays.asList(MakeCorePlugin.getDefault().getTargetManager().getTargets((IContainer)obj)));
                }
                catch (CoreException coreException) {}
                return children.toArray();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object obj) {
        if (obj instanceof IMakeTarget) {
            return ((IMakeTarget)obj).getContainer();
        }
        if (obj instanceof IContainer) {
            return ((IContainer)obj).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object obj) {
        return this.getChildren(obj).length > 0;
    }

    public Object[] getElements(Object obj) {
        if (this.bFlatten) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] children = this.getChildren(obj);
            int i = 0;
            while (i < children.length) {
                list.add(children[i]);
                list.addAll(Arrays.asList(this.getElements(children[i])));
                ++i;
            }
            return list.toArray();
        }
        return this.getChildren(obj);
    }

    public void dispose() {
        if (this.viewer != null) {
            MakeCorePlugin.getDefault().getTargetManager().removeListener((IMakeTargetListener)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer == null) {
            MakeCorePlugin.getDefault().getTargetManager().addListener((IMakeTargetListener)this);
        }
        this.viewer = (StructuredViewer)viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    public void targetChanged(final MakeTargetEvent event) {
        final Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            switch (event.getType()) {
                case 4: 
                case 5: {
                    ctrl.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (ctrl != null && !ctrl.isDisposed()) {
                                MakeContentProvider.this.viewer.refresh();
                            }
                        }
                    });
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    ctrl.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (ctrl != null && !ctrl.isDisposed()) {
                                if (MakeContentProvider.this.bFlatten) {
                                    MakeContentProvider.this.viewer.refresh();
                                } else {
                                    MakeContentProvider.this.viewer.refresh((Object)event.getTarget().getContainer());
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    void processDelta(IResourceDelta delta) {
        int i;
        ArrayList<IResource> affected;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed() || delta == null) {
            return;
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                return;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < affectedChildren.length) {
            this.processDelta(affectedChildren[i2]);
            ++i2;
        }
        IResource resource = delta.getResource();
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            affected = new ArrayList<IResource>(affectedChildren.length);
            i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getResource().getType() == 2) {
                    affected.add(affectedChildren[i].getResource());
                }
                ++i;
            }
            if (affected.size() != 0) {
                if (this.viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)this.viewer).remove(affected.toArray());
                } else {
                    this.viewer.refresh((Object)resource);
                }
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            affected = new ArrayList(affectedChildren.length);
            i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getResource().getType() == 2) {
                    affected.add(affectedChildren[i].getResource());
                }
                ++i;
            }
            if (affected.size() != 0) {
                if (this.viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)this.viewer).add((Object)resource, affected.toArray());
                } else {
                    this.viewer.refresh((Object)resource);
                }
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MakeContentProvider.this.processDelta(delta);
                }
            });
        }
    }
}

