/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;

public class RefactoringASTParser {
    private ASTParser fParser;

    public RefactoringASTParser(int level) {
        this.fParser = ASTParser.newParser((int)level);
    }

    public CompilationUnit parse(ICompilationUnit unit, boolean resolveBindings) {
        return this.parse(unit, resolveBindings, null);
    }

    public CompilationUnit parse(ICompilationUnit unit, boolean resolveBindings, IProgressMonitor pm) {
        return this.parse(unit, null, resolveBindings, pm);
    }

    public CompilationUnit parse(ICompilationUnit unit, WorkingCopyOwner owner, boolean resolveBindings, IProgressMonitor pm) {
        return this.parse(unit, owner, resolveBindings, false, pm);
    }

    public CompilationUnit parse(ICompilationUnit unit, WorkingCopyOwner owner, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setSource(unit);
        if (owner != null) {
            this.fParser.setWorkingCopyOwner(owner);
        }
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)unit));
        CompilationUnit result = (CompilationUnit)this.fParser.createAST(pm);
        return result;
    }

    public CompilationUnit parse(String newCuSource, ICompilationUnit originalCu, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setSource(newCuSource.toCharArray());
        this.fParser.setUnitName(originalCu.getElementName());
        this.fParser.setProject(originalCu.getJavaProject());
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)originalCu));
        CompilationUnit newCUNode = (CompilationUnit)this.fParser.createAST(pm);
        return newCUNode;
    }

    public CompilationUnit parse(IClassFile unit, boolean resolveBindings) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setSource(unit);
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)unit));
        CompilationUnit result = (CompilationUnit)this.fParser.createAST(null);
        return result;
    }

    public CompilationUnit parse(String newCfSource, IClassFile originalCf, boolean resolveBindings, boolean statementsRecovery, IProgressMonitor pm) {
        this.fParser.setResolveBindings(resolveBindings);
        this.fParser.setStatementsRecovery(statementsRecovery);
        this.fParser.setSource(newCfSource.toCharArray());
        String cfName = originalCf.getElementName();
        this.fParser.setUnitName(String.valueOf(cfName.substring(0, cfName.length() - 6)) + ".java");
        this.fParser.setProject(originalCf.getJavaProject());
        this.fParser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)originalCf));
        CompilationUnit newCUNode = (CompilationUnit)this.fParser.createAST(pm);
        return newCUNode;
    }

    public static CompilationUnit parseWithASTProvider(ICompilationUnit unit, boolean resolveBindings, IProgressMonitor pm) {
        CompilationUnit cuNode = ASTProvider.getASTProvider().getAST((IJavaElement)unit, ASTProvider.WAIT_ACTIVE_ONLY, pm);
        if (cuNode != null) {
            return cuNode;
        }
        return new RefactoringASTParser(3).parse(unit, null, resolveBindings, true, pm);
    }

    public static ICompilationUnit getCompilationUnit(ASTNode node) {
        IJavaElement cu;
        ASTNode root = node.getRoot();
        if (root instanceof CompilationUnit && (cu = ((CompilationUnit)root).getJavaElement()) instanceof ICompilationUnit) {
            return (ICompilationUnit)cu;
        }
        return null;
    }

    public static Map getCompilerOptions(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        Map options = project.getOptions(true);
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value)) continue;
            options.put(key, "ignore");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }
}

