/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ExpressionsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ExpressionsCleanUp
extends AbstractCleanUp {
    public static final int ADD_PARANOIC_PARENTHESIS = 1;
    public static final int REMOVE_UNNECESSARY_PARENTHESIS = 2;
    private static final int DEFAULT_FLAG = 0;
    private static final String SECTION_NAME = "CleanUp_Expressions";

    public ExpressionsCleanUp(int flag) {
        super(flag);
    }

    public ExpressionsCleanUp(IDialogSettings settings) {
        super(ExpressionsCleanUp.getSection(settings, SECTION_NAME), 0);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return ExpressionsFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(2));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return this.createFix(compilationUnit);
    }

    public Map getRequiredOptions() {
        return new Hashtable();
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(ExpressionsCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.ExpressionsCleanUp_addParanoiac_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.ExpressionsCleanUp_removeUnnecessary_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isFlag(1)) {
            buf.append("boolean b= (((i > 0) && (i < 10)) || (i == 50));\n");
        } else if (this.isFlag(2)) {
            buf.append("boolean b= i > 0 && i < 10 || i == 50;\n");
        } else {
            buf.append("boolean b= (i > 0 && i < 10 || i == 50);\n");
        }
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        IFix fix;
        if (this.isFlag(1) && (fix = ExpressionsFix.createAddParanoidalParenthesisFix(compilationUnit, new ASTNode[]{problem.getCoveredNode(compilationUnit)})) != null) {
            return true;
        }
        return this.isFlag(2) && (fix = ExpressionsFix.createRemoveUnnecessaryParenthesisFix(compilationUnit, new ASTNode[]{problem.getCoveredNode(compilationUnit)})) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public int getDefaultFlag() {
        return 0;
    }
}

