/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;

public class ProfileManager
extends Observable {
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";
    public static final String ECLIPSE21_PROFILE = "org.eclipse.jdt.ui.default_profile";
    public static final String ECLIPSE_PROFILE = "org.eclipse.jdt.ui.default.eclipse_profile";
    public static final String JAVA_PROFILE = "org.eclipse.jdt.ui.default.sun_profile";
    public static final String SHARED_PROFILE = "org.eclipse.jdt.ui.default.shared";
    public static final String DEFAULT_PROFILE = "org.eclipse.jdt.ui.default.eclipse_profile";
    private final Map fProfiles;
    private final List fProfilesByName;
    private Profile fSelected;
    private static final List fUIKeys = Collections.EMPTY_LIST;
    private static final List fCoreKeys = new ArrayList(DefaultCodeFormatterConstants.getJavaConventionsSettings().keySet());
    private static final List fKeys = new ArrayList();
    private final PreferencesAccess fPreferencesAccess;

    static {
        fKeys.addAll(fUIKeys);
        fKeys.addAll(fCoreKeys);
        Collections.sort(fKeys);
    }

    public ProfileManager(List profiles, IScopeContext context, PreferencesAccess preferencesAccess) {
        block5: {
            String projProfileId;
            Profile matching;
            Map map;
            block7: {
                block6: {
                    Profile profile;
                    String tabSetting;
                    IEclipsePreferences node;
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfiles = new HashMap();
                    this.fProfilesByName = new ArrayList();
                    this.addBuiltinProfiles(this.fProfiles, this.fProfilesByName);
                    Iterator iter = profiles.iterator();
                    while (iter.hasNext()) {
                        CustomProfile profile2 = (CustomProfile)iter.next();
                        profile2.setManager(this);
                        this.fProfiles.put(profile2.getID(), profile2);
                        this.fProfilesByName.add(profile2);
                    }
                    Collections.sort(this.fProfilesByName);
                    IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
                    String profileId = instanceScope.getNode("org.eclipse.jdt.ui").get(PROFILE_KEY, null);
                    if (profileId == null && "org.eclipse.jdt.ui.default.eclipse_profile".equals(profileId = new DefaultScope().getNode("org.eclipse.jdt.ui").get(PROFILE_KEY, null)) && (node = instanceScope.getNode("org.eclipse.jdt.core")) != null && "space".equals(tabSetting = node.get("org.eclipse.jdt.core.formatter.tabulation.char", null))) {
                        profileId = JAVA_PROFILE;
                    }
                    if ((profile = (Profile)this.fProfiles.get(profileId)) == null) {
                        profile = (Profile)this.fProfiles.get("org.eclipse.jdt.ui.default.eclipse_profile");
                    }
                    this.fSelected = profile;
                    if (context.getName() != "project" || !ProfileManager.hasProjectSpecificSettings(context) || (map = this.readFromPreferenceStore(context, profile)) == null) break block5;
                    matching = null;
                    projProfileId = context.getNode("org.eclipse.jdt.ui").get(PROFILE_KEY, null);
                    if (projProfileId == null) break block6;
                    Profile curr = (Profile)this.fProfiles.get(projProfileId);
                    if (curr == null || !curr.isBuiltInProfile() && !curr.hasEqualSettings(map, ProfileManager.getKeys())) break block7;
                    matching = curr;
                    break block7;
                }
                Iterator iter = this.fProfilesByName.iterator();
                while (iter.hasNext()) {
                    Profile curr = (Profile)iter.next();
                    if (!curr.hasEqualSettings(map, ProfileManager.getKeys())) continue;
                    matching = curr;
                    break;
                }
            }
            if (matching == null) {
                String name = projProfileId != null && !this.fProfiles.containsKey(projProfileId) ? Messages.format(FormatterMessages.ProfileManager_unmanaged_profile_with_name, projProfileId.substring(ID_PREFIX.length())) : FormatterMessages.ProfileManager_unmanaged_profile;
                SharedProfile shared = new SharedProfile(name, map);
                shared.setManager(this);
                this.fProfiles.put(shared.getID(), shared);
                this.fProfilesByName.add(shared);
                matching = shared;
            }
            this.fSelected = matching;
        }
    }

    protected void notifyObservers(int message) {
        this.setChanged();
        this.notifyObservers(new Integer(message));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext context) {
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        Iterator keyIter = fCoreKeys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String val = corePrefs.get(key, null);
            if (val == null) continue;
            return true;
        }
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        Iterator keyIter2 = fUIKeys.iterator();
        while (keyIter2.hasNext()) {
            String key = (String)keyIter2.next();
            String val = uiPrefs.get(key, null);
            if (val == null) continue;
            return true;
        }
        return false;
    }

    public Map readFromPreferenceStore(IScopeContext context, Profile workspaceProfile) {
        String val;
        String key;
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        int version = uiPrefs.getInt(FORMATTER_SETTINGS_VERSION, 1);
        if (version != 10) {
            HashMap allOptions = new HashMap();
            this.addAll(uiPrefs, allOptions);
            this.addAll(corePrefs, allOptions);
            return ProfileVersioner.updateAndComplete(allOptions, version);
        }
        boolean hasValues = false;
        Iterator keyIter = fCoreKeys.iterator();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            val = corePrefs.get(key, null);
            if (val != null) {
                hasValues = true;
            } else {
                val = workspaceProfile.getSettings().get(key);
            }
            profileOptions.put(key, val);
        }
        keyIter = fUIKeys.iterator();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            val = uiPrefs.get(key, null);
            if (val != null) {
                hasValues = true;
            } else {
                val = workspaceProfile.getSettings().get(key);
            }
            profileOptions.put(key, val);
        }
        if (!hasValues) {
            return null;
        }
        ProfileVersioner.setLatestCompliance(profileOptions);
        return profileOptions;
    }

    private void addAll(IEclipsePreferences uiPrefs, Map allOptions) {
        try {
            String[] keys = uiPrefs.keys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String val = uiPrefs.get(key, null);
                if (val != null) {
                    allOptions.put(key, val);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences prefs, List keys, Map profileOptions) {
        boolean hasChanges = false;
        Iterator keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String oldVal = prefs.get(key, null);
            String val = (String)profileOptions.get(key);
            if (val == null) {
                if (oldVal == null) continue;
                prefs.remove(key);
                hasChanges = true;
                continue;
            }
            if (val.equals(oldVal)) continue;
            prefs.put(key, val);
            hasChanges = true;
        }
        return hasChanges;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext context) {
        Map profileOptions = profile.getSettings();
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        this.updatePreferences(corePrefs, fCoreKeys, profileOptions);
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        this.updatePreferences(uiPrefs, fUIKeys, profileOptions);
        if (uiPrefs.getInt(FORMATTER_SETTINGS_VERSION, 0) != 10) {
            uiPrefs.putInt(FORMATTER_SETTINGS_VERSION, 10);
        }
        if (context.getName() == "instance") {
            uiPrefs.put(PROFILE_KEY, profile.getID());
        } else if (context.getName() == "project" && !profile.isSharedProfile()) {
            uiPrefs.put(PROFILE_KEY, profile.getID());
        }
    }

    private void addBuiltinProfiles(Map profiles, List profilesByName) {
        BuiltInProfile javaProfile = new BuiltInProfile(JAVA_PROFILE, FormatterMessages.ProfileManager_java_conventions_profile_name, ProfileManager.getJavaSettings(), 1);
        profiles.put(((Profile)javaProfile).getID(), javaProfile);
        profilesByName.add(javaProfile);
        BuiltInProfile eclipseProfile = new BuiltInProfile("org.eclipse.jdt.ui.default.eclipse_profile", FormatterMessages.ProfileManager_eclipse_profile_name, ProfileManager.getEclipseSettings(), 2);
        profiles.put(((Profile)eclipseProfile).getID(), eclipseProfile);
        profilesByName.add(eclipseProfile);
        BuiltInProfile eclipse21Profile = new BuiltInProfile(ECLIPSE21_PROFILE, FormatterMessages.ProfileManager_default_profile_name, ProfileManager.getEclipse21Settings(), 3);
        profiles.put(((Profile)eclipse21Profile).getID(), eclipse21Profile);
        profilesByName.add(eclipse21Profile);
    }

    public static Map getEclipse21Settings() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getEclipseSettings() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getJavaSettings() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        ProfileVersioner.setLatestCompliance(options);
        return options;
    }

    public static Map getDefaultSettings() {
        return ProfileManager.getEclipseSettings();
    }

    public static List getKeys() {
        return fKeys;
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] sortedNames = new String[this.fProfilesByName.size()];
        int i = 0;
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            Profile curr = (Profile)iter.next();
            sortedNames[i++] = curr.getName();
        }
        return sortedNames;
    }

    public Profile getProfile(String ID) {
        return (Profile)this.fProfiles.get(ID);
    }

    public void commitChanges(IScopeContext scopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, scopeContext);
        }
    }

    public void clearAllSettings(IScopeContext context) {
        IEclipsePreferences corePrefs = context.getNode("org.eclipse.jdt.core");
        this.updatePreferences(corePrefs, fCoreKeys, Collections.EMPTY_MAP);
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        this.updatePreferences(uiPrefs, fUIKeys, Collections.EMPTY_MAP);
        uiPrefs.remove(PROFILE_KEY);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile newSelected = (Profile)this.fProfiles.get(profile.getID());
        if (newSelected != null && !newSelected.equals(this.fSelected)) {
            this.fSelected = newSelected;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String name) {
        Iterator iter = this.fProfilesByName.iterator();
        while (iter.hasNext()) {
            Profile curr = (Profile)iter.next();
            if (!name.equals(curr.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile profile) {
        profile.setManager(this);
        CustomProfile oldProfile = (CustomProfile)this.fProfiles.get(profile.getID());
        if (oldProfile != null) {
            this.fProfiles.remove(oldProfile.getID());
            this.fProfilesByName.remove(oldProfile);
            oldProfile.setManager(null);
        }
        this.fProfiles.put(profile.getID(), profile);
        this.fProfilesByName.add(profile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = profile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        Profile removedProfile = this.fSelected;
        int index = this.fProfilesByName.indexOf(removedProfile);
        this.fProfiles.remove(removedProfile.getID());
        this.fProfilesByName.remove(removedProfile);
        ((CustomProfile)removedProfile).setManager(null);
        if (index >= this.fProfilesByName.size()) {
            --index;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(index);
        if (!removedProfile.isSharedProfile()) {
            this.updateProfilesWithName(removedProfile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile profile, String oldID) {
        this.fProfiles.remove(oldID);
        this.fProfiles.put(profile.getID(), profile);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(oldID, profile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile oldProfile, CustomProfile newProfile) {
        this.fProfiles.remove(oldProfile.getID());
        this.fProfiles.put(newProfile.getID(), newProfile);
        this.fProfilesByName.remove(oldProfile);
        this.fProfilesByName.add(newProfile);
        Collections.sort(this.fProfilesByName);
        if (!oldProfile.isSharedProfile()) {
            this.updateProfilesWithName(oldProfile.getID(), null, false);
        }
        this.setSelected(newProfile);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile profile) {
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), profile, true);
        }
        this.notifyObservers(5);
    }

    private void updateProfilesWithName(String oldName, Profile newProfile, boolean applySettings) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IScopeContext projectScope = this.fPreferencesAccess.getProjectScope(projects[i]);
            IEclipsePreferences node = projectScope.getNode("org.eclipse.jdt.ui");
            String profileId = node.get(PROFILE_KEY, null);
            if (oldName.equals(profileId)) {
                if (newProfile == null) {
                    node.remove(PROFILE_KEY);
                } else if (applySettings) {
                    this.writeToPreferenceStore(newProfile, projectScope);
                } else {
                    node.put(PROFILE_KEY, newProfile.getID());
                }
            }
            ++i;
        }
        IScopeContext instanceScope = this.fPreferencesAccess.getInstanceScope();
        IEclipsePreferences uiPrefs = instanceScope.getNode("org.eclipse.jdt.ui");
        if (newProfile != null && oldName.equals(uiPrefs.get(PROFILE_KEY, null))) {
            this.writeToPreferenceStore(newProfile, instanceScope);
        }
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public int getVersion() {
            return 10;
        }

        public boolean hasEqualSettings(Map otherMap, List allKeys) {
            Map settings = this.getSettings();
            Iterator iter = allKeys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object other = otherMap.get(key);
                Object curr = settings.get(key);
                if (!(other == null ? curr != null : !other.equals(curr))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;
        private final int fOrder;

        protected BuiltInProfile(String ID, String name, Map settings, int order) {
            this.fName = name;
            this.fID = ID;
            this.fSettings = settings;
            this.fOrder = order;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            CustomProfile newProfile = new CustomProfile(trimmed, this.fSettings, 10);
            manager.addProfile(newProfile);
            return newProfile;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
        }

        public String getID() {
            return this.fID;
        }

        public final int compareTo(Object o) {
            if (o instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)o).fOrder;
            }
            return -1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return true;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        protected ProfileManager fManager;
        private int fVersion;

        public CustomProfile(String name, Map settings, int version) {
            this.fName = name;
            this.fSettings = settings;
            this.fVersion = version;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String name, ProfileManager manager) {
            String trimmed = name.trim();
            if (trimmed.equals(this.getName())) {
                return this;
            }
            String oldID = this.getID();
            this.fName = trimmed;
            manager.profileRenamed(this, oldID);
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map settings) {
            if (settings == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = settings;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int version) {
            this.fVersion = version;
        }

        public int compareTo(Object o) {
            if (o instanceof SharedProfile) {
                return -1;
            }
            if (o instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)o).getName());
            }
            return 1;
        }

        public boolean isProfileToSave() {
            return true;
        }
    }

    public static final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String oldName, Map options) {
            super(oldName, options, 10);
        }

        public Profile rename(String name, ProfileManager manager) {
            CustomProfile profile = new CustomProfile(name.trim(), this.getSettings(), this.getVersion());
            manager.profileReplaced(this, profile);
            return profile;
        }

        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        public final int compareTo(Object o) {
            return 1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isSharedProfile() {
            return true;
        }
    }
}

