/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class BuildFilesAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow workbenchWindow = null;
    private IAction action = null;
    static /* synthetic */ Class class$0;

    public BuildFilesAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public BuildFilesAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
    }

    public void dispose() {
    }

    public void init(IAction action) {
        this.action = action;
        this.update();
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }

    private IFile convertToIFile(Object object) {
        IResource resource;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof IAdaptable) {
            IFile file;
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)adaptable.getAdapter((Class)clazz)) != null) {
                return file;
            }
        }
        if (object instanceof ITranslationUnit && (resource = ((ITranslationUnit)object).getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private List getSelectedBuildableFiles() {
        LinkedList<IFile> files = new LinkedList<IFile>();
        ISelectionService selectionService = this.workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator elements = structuredSelection.iterator();
            while (elements.hasNext()) {
                IManagedBuildInfo buildInfo;
                IFile file = this.convertToIFile(elements.next());
                if (file == null || (buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject())) == null || !buildInfo.isValid() || !buildInfo.buildsFileType(file.getFileExtension())) continue;
                files.add(file);
            }
        }
        return files;
    }

    public void run(IAction action) {
        List selectedFiles = this.getSelectedBuildableFiles();
        BuildFilesJob buildFilesJob = new BuildFilesJob(selectedFiles);
        buildFilesJob.schedule();
    }

    private boolean shouldBeEnabled() {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (preferences.getBoolean("description.autobuilding")) {
            return false;
        }
        ISelectionService selectionService = this.workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() <= 0) {
                return false;
            }
            Iterator elements = structuredSelection.iterator();
            while (elements.hasNext()) {
                IFile file = this.convertToIFile(elements.next());
                if (file != null) {
                    if (!ManagedBuildManager.manages((IResource)file.getProject())) {
                        return false;
                    }
                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject());
                    if (buildInfo == null || !buildInfo.isValid()) {
                        return false;
                    }
                    IManagedBuilderMakefileGenerator buildfileGenerator = ManagedBuildManager.getBuildfileGenerator((IConfiguration)buildInfo.getDefaultConfiguration());
                    if (buildfileGenerator == null) {
                        return false;
                    }
                    buildfileGenerator.initialize(file.getProject(), buildInfo, (IProgressMonitor)new NullProgressMonitor());
                    if (buildInfo.buildsFileType(file.getFileExtension()) && !buildfileGenerator.isGeneratedResource((IResource)file)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void update() {
        if (this.action != null) {
            this.action.setEnabled(this.shouldBeEnabled());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.update();
    }

    private static final class BuildFilesJob
    extends Job {
        private final List files;

        BuildFilesJob(List filesToBuild) {
            super(ManagedMakeMessages.getResourceString((String)"BuildFilesAction.buildingSelectedFiles"));
            this.files = filesToBuild;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Iterator iterator = this.files.iterator();
            GeneratedMakefileBuilder builder = new GeneratedMakefileBuilder();
            monitor.beginTask(ManagedMakeMessages.getResourceString((String)"BuildFilesAction.building"), this.files.size());
            boolean isFirstFile = true;
            while (iterator.hasNext()) {
                IFile file = (IFile)iterator.next();
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject());
                IResource[] resources = new IResource[]{file};
                builder.invokeInternalBuilder(resources, buildInfo.getDefaultConfiguration(), false, false, isFirstFile, !iterator.hasNext(), monitor);
                if (isFirstFile) {
                    isFirstFile = false;
                }
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

