/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.properties.NewConfigurationDialog;
import org.eclipse.cdt.managedbuilder.ui.properties.RenameConfigurationDialog;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ManageConfigDialog
extends Dialog {
    private static final String CMN_PREFIX = "BuildPropertyCommon";
    private static final String CMN_LABEL = "BuildPropertyCommon.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String PREFIX = "ManageConfig";
    private static final String LABEL = "ManageConfig.label";
    private static final String CONVERSION_TARGET_LABEL = "ManageConfig.label.conversionTargetLabel";
    private static final String CONVERT_TARGET = "ManageConfig.label.convertTarget";
    private static final String RENAME = "ManageConfig.label.rename";
    private static final String CONFIGS = "ManageConfig.label.configs";
    private static final String CURRENT_CONFIGS = "ManageConfig.label.configs.current";
    private static final String DELETED_CONFIGS = "ManageConfig.label.configs.deleted";
    private static final String NEW_CONF_DLG = "ManageConfig.label.new.config.dialog";
    private static final String RENAME_CONF_DLG = "ManageConfig.label.rename.config.dialog";
    private static final String TIP = "ManageConfig.tip";
    private static final String CONVERSION_TARGET_TIP = "ManageConfig.tip.conversionTarget";
    private static final String CONVERT_TIP = "ManageConfig.tip.convert";
    private static final String EMPTY_STRING = new String();
    private SortedMap deletedConfigs;
    private SortedMap existingConfigs;
    private IManagedProject managedProject;
    IConfiguration selectedConfiguration;
    private String title = "";
    private Combo conversionTargetSelector;
    private Button convertTargetBtn;
    private Composite conversionGroup;
    private SortedMap conversionTargets;
    protected List currentConfigList;
    protected Button newBtn;
    protected Button okBtn;
    protected Button removeBtn;
    protected Button renameBtn;

    protected ManageConfigDialog(Shell parentShell, String title, IManagedProject proj) {
        super(parentShell);
        this.title = title;
        this.managedProject = proj;
        this.getExistingConfigs().clear();
        IConfiguration[] configs = this.managedProject.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            String name = configuration.getName();
            String description = configuration.getDescription();
            String nameAndDescription = new String();
            nameAndDescription = description == null || description.equals("") ? name : String.valueOf(name) + "( " + description + " )";
            this.getExistingConfigs().put(nameAndDescription, configuration);
            ++i;
        }
        this.selectedConfiguration = ManagedBuildManager.getSelectedConfiguration((IProject)this.getProject());
        this.getDeletedConfigs().clear();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.updateButtons();
    }

    private void createConfigListGroup(Composite parent) {
        Group configListGroup = new Group(parent, 0);
        configListGroup.setFont(parent.getFont());
        configListGroup.setText(ManagedBuilderUIMessages.getResourceString(CONFIGS));
        configListGroup.setLayout((Layout)new GridLayout(1, false));
        configListGroup.setLayoutData((Object)new GridData(1808));
        this.currentConfigList = new List((Composite)configListGroup, 2820);
        this.currentConfigList.setFont(configListGroup.getFont());
        GridData data = new GridData(1808);
        data.widthHint = 200;
        this.currentConfigList.setLayoutData((Object)data);
        this.currentConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ManageConfigDialog.this.currentConfigList = null;
            }
        });
        this.currentConfigList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManageConfigDialog.this.handleConfigSelection();
            }
        });
        this.conversionGroup = new Composite((Composite)configListGroup, 0);
        this.conversionGroup.setFont(configListGroup.getFont());
        this.conversionGroup.setLayout((Layout)new GridLayout(2, true));
        this.conversionGroup.setLayoutData((Object)new GridData(768));
        ControlFactory.createLabel((Composite)this.conversionGroup, (String)ManagedBuilderUIMessages.getResourceString(CONVERSION_TARGET_LABEL));
        this.conversionTargetSelector = new Combo(this.conversionGroup, 12);
        this.conversionTargetSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManageConfigDialog.this.handleConversionTargetSelection();
            }
        });
        this.conversionTargetSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONVERSION_TARGET_TIP));
        this.conversionTargetSelector.setLayoutData((Object)new GridData(768));
        Composite buttonBar = new Composite((Composite)configListGroup, 0);
        buttonBar.setFont(configListGroup.getFont());
        buttonBar.setLayout((Layout)new GridLayout(4, true));
        buttonBar.setLayoutData((Object)new GridData(768));
        this.convertTargetBtn = ControlFactory.createPushButton((Composite)buttonBar, (String)ManagedBuilderUIMessages.getResourceString(CONVERT_TARGET));
        this.convertTargetBtn.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONVERT_TIP));
        this.convertTargetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleConversionTargetSelection();
            }
        });
        this.newBtn = new Button(buttonBar, 8);
        this.newBtn.setFont(buttonBar.getFont());
        this.newBtn.setText(ManagedBuilderUIMessages.getResourceString(NEW));
        this.setButtonLayoutData(this.newBtn);
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.newBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.newBtn = null;
            }
        });
        this.removeBtn = new Button(buttonBar, 8);
        this.removeBtn.setFont(buttonBar.getFont());
        this.removeBtn.setText(ManagedBuilderUIMessages.getResourceString(REMOVE));
        this.setButtonLayoutData(this.removeBtn);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.removeBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.removeBtn = null;
            }
        });
        this.renameBtn = new Button(buttonBar, 8);
        this.renameBtn.setFont(buttonBar.getFont());
        this.renameBtn.setText(ManagedBuilderUIMessages.getResourceString(RENAME));
        this.setButtonLayoutData(this.renameBtn);
        this.renameBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageConfigDialog.this.handleRenamePressed();
            }
        });
        this.renameBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ManageConfigDialog.this.renameBtn = null;
            }
        });
    }

    private void handleConversionTargetSelection() {
        IConfigurationElement element = null;
        String selectedConversionTargetName = null;
        int selectionIndex = this.conversionTargetSelector.getSelectionIndex();
        if (selectionIndex != -1) {
            selectedConversionTargetName = this.conversionTargetSelector.getItem(selectionIndex);
            element = (IConfigurationElement)this.getConversionTargets().get(selectedConversionTargetName);
            Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
            boolean shouldConvert = MessageDialog.openQuestion((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ConfigurationConvert.confirmdialog.title"), (String)ManagedBuilderUIMessages.getFormattedString("ConfigurationConvert.confirmdialog.message", new String[]{this.getSelectedConfiguration().getName(), this.getSelectedConfiguration().getToolChain().getName(), element.getAttribute("name")}));
            if (shouldConvert) {
                IConvertManagedBuildObject convertBuildObject = null;
                try {
                    convertBuildObject = (IConvertManagedBuildObject)element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                String fromId = element.getAttribute("fromId");
                String toId = element.getAttribute("toId");
                if (convertBuildObject != null) {
                    IConfiguration configuration = (IConfiguration)convertBuildObject.convert((IBuildObject)this.getSelectedConfiguration().getToolChain(), fromId, toId, true);
                    int configSelectionIndex = this.currentConfigList.getSelectionIndex();
                    String selectedConfigNameAndDescription = this.currentConfigList.getItem(configSelectionIndex);
                    this.getExistingConfigs().remove(selectedConfigNameAndDescription);
                    String name = configuration.getName();
                    String description = configuration.getDescription();
                    String nameAndDescription = new String();
                    nameAndDescription = description == null || description.equals("") ? name : String.valueOf(name) + "( " + description + " )";
                    this.setSelectedConfiguration(configuration);
                    this.getExistingConfigs().put(nameAndDescription, configuration);
                    this.currentConfigList.removeAll();
                    this.currentConfigList.setItems(this.getConfigurationNamesAndDescriptions());
                    this.currentConfigList.select(this.currentConfigList.indexOf(nameAndDescription));
                    this.updateConversionTargets(configuration);
                }
            }
            this.updateButtons();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.createConfigListGroup(comp);
        this.currentConfigList.setItems(this.getConfigurationNamesAndDescriptions());
        String name = this.getSelectedConfiguration().getName();
        String description = this.getSelectedConfiguration().getDescription();
        String nameAndDescription = new String();
        nameAndDescription = description == null || description.equals("") ? name : String.valueOf(name) + "( " + description + " )";
        this.currentConfigList.select(this.currentConfigList.indexOf(nameAndDescription));
        this.updateConversionTargets(this.getSelectedConfiguration());
        this.newBtn.setFocus();
        return comp;
    }

    private String[] getConversionTargetList(IConfiguration config) {
        String[] emptyList = new String[]{};
        String fromId = null;
        config.getToolChain().getId();
        this.getConversionTargets().clear();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        if (this.hasToolChainConverters(config.getToolChain(), fromId)) {
                            this.getConversionTargets().put(element.getAttribute("name"), element);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.getConversionTargets().isEmpty()) {
            return emptyList;
        }
        return this.getConversionTargets().keySet().toArray(new String[this.getConversionTargets().size()]);
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasToolChainConverters(IToolChain toolChain, String fromId) {
        if (fromId != null) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            id = toolChain.getId();
            if (fromId.equals(id)) {
                return true;
            }
            toolChain = toolChain.getSuperClass();
lbl7:
            // 2 sources

            ** while (toolChain != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    private void updateConversionTargets(IConfiguration config) {
        this.conversionTargetSelector.setItems(this.getConversionTargetList(config));
        this.conversionTargetSelector.select(0);
        this.conversionGroup.setEnabled(this.conversionTargetSelector.getItemCount() > 0);
        this.convertTargetBtn.setEnabled(this.conversionTargetSelector.getItemCount() > 0);
    }

    private String[] getConfigurationNamesAndDescriptions() {
        String[] namesAndDescriptions = this.getExistingConfigs().keySet().toArray(new String[this.getExistingConfigs().size()]);
        return namesAndDescriptions;
    }

    protected SortedMap getDeletedConfigs() {
        if (this.deletedConfigs == null) {
            this.deletedConfigs = new TreeMap();
        }
        return this.deletedConfigs;
    }

    public ArrayList getDeletedConfigIds() {
        return new ArrayList(this.getDeletedConfigs().values());
    }

    protected SortedMap getExistingConfigs() {
        if (this.existingConfigs == null) {
            this.existingConfigs = new TreeMap();
        }
        return this.existingConfigs;
    }

    protected SortedMap getConversionTargets() {
        if (this.conversionTargets == null) {
            this.conversionTargets = new TreeMap();
        }
        return this.conversionTargets;
    }

    private IProject getProject() {
        return (IProject)this.managedProject.getOwner();
    }

    protected void handleNewPressed() {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        NewConfigurationDialog dialog = new NewConfigurationDialog(this.getShell(), this.managedProject, ManagedBuilderUIMessages.getResourceString(NEW_CONF_DLG));
        if (dialog.open() == 0) {
            String newConfigName = dialog.getNewName();
            String newConfigDescription = dialog.getNewDescription();
            IConfiguration parentConfig = dialog.getParentConfiguration();
            if (parentConfig != null) {
                IConfiguration newConfig = dialog.newConfiguration(info);
                String nameAndDescription = new String();
                nameAndDescription = newConfigDescription == null || newConfigDescription.equals("") ? newConfigName : String.valueOf(newConfigName) + "( " + newConfigDescription + " )";
                this.getExistingConfigs().put(nameAndDescription, newConfig);
                this.setSelectedConfiguration(newConfig);
                this.currentConfigList.setItems(this.getConfigurationNamesAndDescriptions());
                int configIndex = this.currentConfigList.indexOf(nameAndDescription);
                this.currentConfigList.setSelection(configIndex);
                this.updateConversionTargets(newConfig);
            }
        }
        this.updateButtons();
    }

    protected void handleRenamePressed() {
        IConfiguration selectedConfig = null;
        String selectedConfigNameAndDescription = null;
        int selectionIndex = this.currentConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            selectedConfigNameAndDescription = this.currentConfigList.getItem(selectionIndex);
            selectedConfig = (IConfiguration)this.getExistingConfigs().get(selectedConfigNameAndDescription);
            RenameConfigurationDialog dialog = new RenameConfigurationDialog(this.getShell(), this.managedProject, selectedConfig, ManagedBuilderUIMessages.getResourceString(RENAME_CONF_DLG));
            if (dialog.open() == 0) {
                String newConfigName = dialog.getNewName();
                String newConfigDescription = dialog.getNewDescription();
                selectedConfig.setName(newConfigName);
                selectedConfig.setDescription(newConfigDescription);
                this.getExistingConfigs().remove(selectedConfigNameAndDescription);
                String nameAndDescription = new String();
                nameAndDescription = newConfigDescription == null || newConfigDescription.equals("") ? newConfigName : String.valueOf(newConfigName) + "( " + newConfigDescription + " )";
                this.getExistingConfigs().put(nameAndDescription, selectedConfig);
                this.setSelectedConfiguration(selectedConfig);
                this.currentConfigList.setItems(this.getConfigurationNamesAndDescriptions());
                int configIndex = this.currentConfigList.indexOf(nameAndDescription);
                this.currentConfigList.setSelection(configIndex);
                this.updateButtons();
            }
        }
    }

    protected void handleRemovePressed() {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        int selectionIndex = this.currentConfigList.getSelectionIndex();
        if (selectionIndex != -1) {
            String selectedConfigNameAndDescription = this.currentConfigList.getItem(selectionIndex);
            Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
            boolean shouldDelete = MessageDialog.openQuestion((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ManageConfig.deletedialog.title"), (String)ManagedBuilderUIMessages.getFormattedString("ManageConfig.deletedialog.message", new String[]{selectedConfigNameAndDescription}));
            if (shouldDelete) {
                IConfiguration selectedConfig = (IConfiguration)this.getExistingConfigs().get(selectedConfigNameAndDescription);
                String selectedConfigId = selectedConfig.getId();
                this.getDeletedConfigs().put(selectedConfigNameAndDescription, selectedConfigId);
                info.getManagedProject().removeConfiguration(selectedConfigId);
                this.getExistingConfigs().remove(selectedConfigNameAndDescription);
                this.currentConfigList.setItems(this.getConfigurationNamesAndDescriptions());
                this.currentConfigList.setSelection(this.currentConfigList.getItemCount() - 1);
                selectionIndex = this.currentConfigList.getSelectionIndex();
                if (selectionIndex != -1) {
                    selectedConfigNameAndDescription = this.currentConfigList.getItem(selectionIndex);
                    selectedConfig = (IConfiguration)this.getExistingConfigs().get(selectedConfigNameAndDescription);
                    this.setSelectedConfiguration(selectedConfig);
                }
                this.updateConversionTargets(selectedConfig);
                this.updateButtons();
            }
        }
    }

    private void updateButtons() {
        this.removeBtn.setEnabled(this.currentConfigList.getItemCount() > 1);
        this.convertTargetBtn.setEnabled(this.conversionTargetSelector.getItemCount() > 0);
    }

    private void handleConfigSelection() {
        int selectionIndex = this.currentConfigList.getSelectionIndex();
        String selectedConfigNameAndDescription = this.currentConfigList.getItem(selectionIndex);
        IConfiguration selectedConfig = (IConfiguration)this.getExistingConfigs().get(selectedConfigNameAndDescription);
        this.setSelectedConfiguration(selectedConfig);
        this.updateConversionTargets(selectedConfig);
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    public void setSelectedConfiguration(IConfiguration selectedConfiguration) {
        this.selectedConfiguration = selectedConfiguration;
    }
}

