/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.internal.refactoring.ASTManager;
import org.eclipse.cdt.refactoring.ICRefactoringArgument;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRefactoringArgument
implements ICRefactoringArgument {
    private int fOffset = 0;
    private String fText = "";
    private int fKind = 0;
    private IFile fFile;
    private IBinding fBinding;
    private IScope fScope;
    private IASTTranslationUnit fTranslationUnit;

    public CRefactoringArgument(ITextEditor editor, ITextSelection selection) {
        this.fText = selection.getText();
        this.fOffset = selection.getOffset();
        if (editor != null) {
            IDocument doc;
            IDocumentProvider dp;
            IEditorInput ei = editor.getEditorInput();
            if (ei instanceof IFileEditorInput) {
                IFileEditorInput fei = (IFileEditorInput)ei;
                this.fFile = fei.getFile();
            }
            if ((dp = editor.getDocumentProvider()) != null && (doc = dp.getDocument((Object)ei)) != null) {
                this.setToWord(doc, selection);
            }
        }
    }

    public CRefactoringArgument(IFile file, int offset, String text) {
        this.fText = text;
        this.fOffset = offset;
        this.fFile = file;
    }

    private void setToWord(IDocument document, ITextSelection sel) {
        char ch;
        int a;
        int offset = sel.getOffset();
        int length = sel.getLength();
        if (length == 0) {
            char chr = '\u0000';
            char chl = '\u0000';
            try {
                chr = document.getChar(offset);
            }
            catch (BadLocationException badLocationException) {}
            try {
                chl = document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {}
            if (this.isPartOfIdentifier(chr)) {
                length = 1;
            } else if (this.isPartOfIdentifier(chl)) {
                --offset;
                length = 1;
            } else {
                return;
            }
        }
        int z = a = offset + length - 1;
        try {
            ch = document.getChar(z);
            while (this.isPartOfIdentifier(ch)) {
                ch = document.getChar(++z);
            }
        }
        catch (BadLocationException badLocationException) {}
        try {
            ch = document.getChar(a);
            while (this.isPartOfIdentifier(ch)) {
                ch = document.getChar(--a);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (a == z) {
            offset = a;
            length = 0;
        } else {
            offset = a + 1;
            length = z - a - 1;
        }
        try {
            this.fText = document.get(offset, length);
            this.fOffset = offset;
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isPartOfIdentifier(char chr) {
        if (chr >= 'a' && chr <= 'z') {
            return true;
        }
        if (chr >= 'A' && chr <= 'Z') {
            return true;
        }
        switch (chr) {
            case '_': {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.fText;
    }

    public IFile getSourceFile() {
        return this.fFile;
    }

    public int getArgumentKind() {
        return this.fKind;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setName(IASTName name) {
        this.fText = name.toString();
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setBinding(IASTTranslationUnit tu, IBinding binding, IScope scope) {
        this.fTranslationUnit = tu;
        this.fBinding = binding;
        this.fScope = scope;
        if (binding instanceof IVariable) {
            IVariable var = (IVariable)binding;
            if (binding instanceof IField) {
                this.fKind = 5;
            } else if (binding instanceof IParameter) {
                this.fKind = 2;
            } else if (ASTManager.isLocalVariable(var, scope)) {
                this.fKind = 1;
            } else {
                boolean isStatic = false;
                try {
                    isStatic = var.isStatic();
                }
                catch (DOMException dOMException) {}
                this.fKind = isStatic ? 3 : 4;
            }
        } else if (binding instanceof IEnumerator) {
            this.fKind = 13;
        } else if (binding instanceof IFunction) {
            this.fKind = 9;
            IFunction func = (IFunction)binding;
            if (binding instanceof ICPPMethod) {
                ICPPMethod method = (ICPPMethod)binding;
                int isVirtual = -1;
                try {
                    isVirtual = ASTManager.isVirtualMethod(method);
                }
                catch (DOMException dOMException) {}
                if (isVirtual == 1) {
                    this.fKind = 8;
                }
            } else {
                boolean isStatic = false;
                try {
                    isStatic = func.isStatic();
                }
                catch (DOMException dOMException) {}
                this.fKind = isStatic ? 6 : 7;
            }
        } else if (binding instanceof ICompositeType) {
            this.fKind = 14;
        } else if (binding instanceof IEnumeration || binding instanceof ITypedef) {
            this.fKind = 10;
        } else if (binding instanceof ICPPNamespace) {
            this.fKind = 15;
        } else if (binding instanceof IMacroBinding) {
            this.fKind = 11;
        }
    }

    public IScope getScope() {
        return this.fScope;
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.fTranslationUnit;
    }
}

