/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class FortranEditorActionDelegate
extends Action
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate,
IRunnableWithProgress {
    private IWorkbenchWindow window = null;
    private AbstractFortranEditor fEditor = null;

    public FortranEditorActionDelegate() {
    }

    public FortranEditorActionDelegate(AbstractFortranEditor ed) {
        this.fEditor = ed;
    }

    public final void run(IAction action) {
        if (this.window != null) {
            IEditorPart editor = this.window.getActivePage().getActiveEditor();
            AbstractFortranEditor abstractFortranEditor = this.fEditor = editor instanceof AbstractFortranEditor ? (AbstractFortranEditor)editor : null;
        }
        if (this.fEditor != null) {
            IProgressService context = PlatformUI.getWorkbench().getProgressService();
            IWorkspaceRoot lockEntireWorkspace = ResourcesPlugin.getWorkspace().getRoot();
            try {
                context.runInUI((IRunnableContext)context, (IRunnableWithProgress)this, (ISchedulingRule)lockEntireWorkspace);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.fEditor.getShell(), (String)"Unhandled Exception", (String)e.getMessage());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor instanceof AbstractFortranEditor ? (AbstractFortranEditor)targetEditor : null;
    }

    protected AbstractFortranEditor getFortranEditor() {
        return this.fEditor;
    }

    protected Shell getShell() {
        return this.fEditor == null ? null : this.fEditor.getShell();
    }

    protected File createTempFile() throws IOException {
        File tempFile = File.createTempFile("photran-tmp", ".txt");
        tempFile.deleteOnExit();
        return tempFile;
    }

    protected PrintStream createPrintStream(File tempFile) throws FileNotFoundException {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
    }

    public void openHtmlViewerOn(String title, String str) {
        try {
            File temp = this.createTempFile();
            PrintStream text = this.createPrintStream(temp);
            text.print(str);
            text.close();
            this.openHtmlViewerOn(title, temp);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)("Unable to create temporary file.\n\n" + e.getMessage()));
        }
    }

    public void openHtmlViewerOn(String title, File file) {
        final class HtmlRunnable
        implements Runnable {
            final /* synthetic */ FortranEditorActionDelegate this$0;
            private final /* synthetic */ String val$title;
            private final /* synthetic */ File val$file;

            HtmlRunnable(FortranEditorActionDelegate fortranEditorActionDelegate, String string, File file) {
                this.this$0 = fortranEditorActionDelegate;
                this.val$title = string;
                this.val$file = file;
            }

            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(0, null, this.val$title, null).openURL(this.val$file.toURL());
                }
                catch (Throwable e) {
                    Display.getDefault().asyncExec(new Runnable(this, e){
                        final /* synthetic */ HtmlRunnable this$1;
                        private final /* synthetic */ Throwable val$e;
                        {
                            this.this$1 = htmlRunnable;
                            this.val$e = throwable;
                        }

                        public void run() {
                            MessageDialog.openError((Shell)HtmlRunnable.access$0(this.this$1).getFortranEditor().getShell(), (String)"Error", (String)("Unable to open Web browser.\n\n" + this.val$e.getMessage()));
                        }
                    });
                }
            }

            static /* synthetic */ FortranEditorActionDelegate access$0(HtmlRunnable htmlRunnable) {
                return htmlRunnable.this$0;
            }
        }
        Display.getDefault().syncExec((Runnable)new HtmlRunnable(this, title, file));
    }
}

