/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class FortranHorizontalRuler
extends Composite {
    protected StyledText fStyledText;
    protected ISourceViewer fSourceViewer;
    protected String fDisplayText;
    protected int fWidth;
    protected static final String BLANK = "";
    protected static final char PLUS = '+';
    protected static final char MINUS = '-';
    protected int avgCharWidth;
    protected static final char TAB = '\t';
    protected static RGB WHITE = new RGB(255, 255, 255);
    protected static RGB BLACK = new RGB(0, 0, 0);
    protected static RGB GRAY = new RGB(190, 190, 190);
    protected static RGB DARK_GRAY = new RGB(128, 128, 128);
    protected static RGB LIGHT_GRAY = new RGB(221, 221, 221);
    protected static Color fWhiteColor = new Color(null, WHITE);
    protected static Color fBlackColor = new Color(null, BLACK);
    protected static Color fGrayColor = new Color(null, GRAY);
    protected static Color fDarkGrayColor = new Color(null, DARK_GRAY);
    protected static Color fLightGrayColor = new Color(null, LIGHT_GRAY);
    protected ISelectionChangedListener fSelectionChangedListener;
    protected PaintListener fPaintListener;
    protected FocusAdapter fFocusAdapter;
    protected VerifyListener fVerifyListener;
    protected VerifyKeyListener fVerifyKeyListener;
    protected SelectionAdapter fSelectionAdapter;
    protected MouseAdapter fMouseAdapter;
    protected IVerticalRuler fVerticalRuler;
    protected boolean fIsFixedForm;

    public FortranHorizontalRuler(IVerticalRuler verticalRuler, Composite parent, boolean isFixedForm) {
        super(parent, 262144);
        this.fVerticalRuler = verticalRuler;
        this.fIsFixedForm = isFixedForm;
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
        this.fStyledText = this.fSourceViewer.getTextWidget();
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FortranHorizontalRuler.this.fSourceViewer.getTextWidget().getSelectionCount() > 0) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(this.fSelectionChangedListener);
        this.fPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                FortranHorizontalRuler.this.paintComponent(e.gc);
            }
        };
        this.addPaintListener(this.fPaintListener);
        this.fFocusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fStyledText.addFocusListener((FocusListener)this.fFocusAdapter);
        this.fVerifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fStyledText.addVerifyListener(this.fVerifyListener);
        this.fVerifyKeyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fStyledText.addVerifyKeyListener(this.fVerifyKeyListener);
        this.fSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fStyledText.getHorizontalBar().addSelectionListener((SelectionListener)this.fSelectionAdapter);
        this.fMouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (!FortranHorizontalRuler.this.fStyledText.isDisposed()) {
                    FortranHorizontalRuler.this.redraw();
                }
            }
        };
        this.fStyledText.addMouseListener((MouseListener)this.fMouseAdapter);
    }

    protected void paintComponent(GC g) {
        int verticalRulerWidth = this.fVerticalRuler.getWidth();
        Point size = this.getSize();
        if (this.fWidth != size.x) {
            this.fWidth = size.x;
        }
        this.avgCharWidth = g.getFontMetrics().getAverageCharWidth();
        int maxChars = this.fIsFixedForm ? 80 : this.fWidth / this.avgCharWidth;
        int height = size.y;
        g.fillRectangle(0, 0, this.fWidth, height);
        g.setBackground(fWhiteColor);
        g.fillRectangle(verticalRulerWidth, 0, this.fWidth - this.fStyledText.getVerticalBar().getSize().x - verticalRulerWidth, height);
        g.setClipping(verticalRulerWidth, 0, this.fWidth - this.fStyledText.getVerticalBar().getSize().x - verticalRulerWidth, height);
        g.setForeground(fDarkGrayColor);
        this.fDisplayText = this.ruler(maxChars, this.fStyledText.getHorizontalPixel());
        int column = this.getCurrentColumn();
        --column;
        int scroll = this.fStyledText.getHorizontalPixel();
        int rem = scroll % this.avgCharWidth;
        int x = (column -= (scroll /= this.avgCharWidth)) * g.getFontMetrics().getAverageCharWidth() - rem;
        g.setBackground(fDarkGrayColor);
        g.drawString(this.fDisplayText, 0 - rem + verticalRulerWidth, 0, true);
        g.setBackground(fLightGrayColor);
        g.fillRectangle(x + verticalRulerWidth, 0, g.getFontMetrics().getAverageCharWidth(), height);
        g.setForeground(fWhiteColor);
        char c = '\u0000';
        int index = column;
        c = index < 0 || index >= this.fDisplayText.length() ? (char)' ' : this.fDisplayText.charAt(index);
        g.drawString(String.valueOf(c), x + verticalRulerWidth, 0, true);
    }

    protected String ruler(int maxCol, int start) {
        StringBuffer horizontalString = new StringBuffer(BLANK);
        int begin = 1;
        int i = begin + (start /= this.avgCharWidth);
        while (i <= maxCol + start) {
            if (i % 10 == 0) {
                horizontalString.append(i / 10 % 10);
            } else if (i % 5 == 0) {
                horizontalString.append('+');
            } else {
                horizontalString.append('-');
            }
            ++i;
        }
        if (this.fIsFixedForm) {
            horizontalString.setCharAt(0, '[');
            horizontalString.setCharAt(begin, ' ');
            horizontalString.setCharAt(begin + 1, ' ');
            horizontalString.setCharAt(begin + 2, ' ');
            horizontalString.setCharAt(begin + 3, ' ');
            horizontalString.setCharAt(begin + 4, ']');
        }
        return horizontalString.toString();
    }

    protected int getCurrentColumn() {
        int column = 0;
        int line = -1;
        try {
            int offset = this.fSourceViewer.getVisibleRegion().getOffset();
            int caret = offset + this.fStyledText.getCaretOffset();
            IDocument document = this.fSourceViewer.getDocument();
            line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = this.fStyledText.getTabs();
            int increment = 1;
            int adjust = 0;
            int i = lineOffset;
            while (i < caret) {
                if ('\t' == document.getChar(i)) {
                    while ((column + increment + adjust) % tabWidth != 0) {
                        ++increment;
                    }
                    column += increment;
                    increment = 1;
                } else {
                    ++column;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return ++column;
    }

    public void dispose() {
        this.fSourceViewer.getSelectionProvider().removeSelectionChangedListener(this.fSelectionChangedListener);
        this.removePaintListener(this.fPaintListener);
        this.fStyledText.removeFocusListener((FocusListener)this.fFocusAdapter);
        this.fStyledText.removeVerifyKeyListener(this.fVerifyKeyListener);
        this.fStyledText.removeVerifyListener(this.fVerifyListener);
        this.fStyledText.getHorizontalBar().removeSelectionListener((SelectionListener)this.fSelectionAdapter);
        this.fStyledText.removeMouseListener((MouseListener)this.fMouseAdapter);
        super.dispose();
    }
}

