/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;
import org.eclipse.ptp.core.attributes.MutableDateAttribute;

public final class DateAttribute
implements IAttribute {
    private final MutableDateAttribute value;

    public DateAttribute(IAttributeDescription description, Calendar value) {
        this(description, value, DateFormat.getDateTimeInstance());
    }

    public DateAttribute(IAttributeDescription description, Calendar value, DateFormat outputDateFormat) {
        this(new MutableDateAttribute(description, value, outputDateFormat));
    }

    public DateAttribute(IAttributeDescription description, Date date) {
        this(description, date, DateFormat.getDateTimeInstance());
    }

    public DateAttribute(IAttributeDescription description, Date date, DateFormat outputDateFormat) {
        this(new MutableDateAttribute(description, date, outputDateFormat));
    }

    public DateAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        this(new MutableDateAttribute(description, string));
    }

    private DateAttribute(MutableDateAttribute mda) {
        this.value = mda;
    }

    public int compareTo(Object arg0) {
        DateAttribute attr = (DateAttribute)arg0;
        return this.value.compareTo(attr.value);
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        MutableDateAttribute mda = new MutableDateAttribute(this.getDescription(), string);
        return new DateAttribute(mda);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateAttribute) {
            DateAttribute attr = (DateAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public Calendar getCalendar() {
        return this.value.getCalendar();
    }

    public Date getDate() {
        return this.value.getDate();
    }

    public IAttributeDescription getDescription() {
        return this.value.getDescription();
    }

    public String getStringRep() {
        return this.value.getStringRep();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

