/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;
import org.eclipse.ptp.core.attributes.IMutableAttribute;

public final class MutableDoubleAttribute
extends AbstractAttribute
implements IMutableAttribute {
    private Double value;

    public MutableDoubleAttribute(IAttributeDescription description, double value) {
        super(description);
        this.value = value;
    }

    public MutableDoubleAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        super(description);
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new MutableDoubleAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableDoubleAttribute) {
            MutableDoubleAttribute attr = (MutableDoubleAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public String getStringRep() {
        return this.value.toString();
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isValid(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(String string) throws IAttribute.IllegalValue {
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        MutableDoubleAttribute attr = (MutableDoubleAttribute)arg0;
        return this.value.compareTo(attr.value);
    }
}

