/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.core.PreferenceConstants;

public class OutputTextFile
implements PreferenceConstants {
    private String filename = "";
    private File file = null;
    private String outputPath = null;
    private int storeLine = 0;
    private int lineCounter = 0;

    public OutputTextFile(String processNumber, String outputPath, int storeLine) {
        this.filename = "process" + processNumber + ".tmp";
        this.outputPath = outputPath;
        this.storeLine = storeLine;
        this.init();
    }

    private void init() {
        this.file = this.getFilePath();
    }

    private File getFilePath() {
        IPath filePath = new Path(this.outputPath).append(this.filename);
        File tmpFile = filePath.toFile();
        try {
            tmpFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println("OutputTextFile - getFilePath err: " + e.getMessage());
        }
        return tmpFile;
    }

    public void write(String text) {
        if (this.lineCounter == this.storeLine) {
            this.lineCounter = 0;
            this.write(text, false);
        } else {
            this.write(text, true);
        }
    }

    public void write(String text, boolean isAppend) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.file, isAppend);
                fos.write(text.getBytes());
                ++this.lineCounter;
            }
            catch (FileNotFoundException e) {
                System.out.println("OutputTextFile - append file err: " + e.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("OutputTextFile - append io err: " + ioe.getMessage());
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    System.out.println("OutputTextFile - append close err: " + ioe.getMessage());
                }
            }
            fos = null;
        }
    }

    public void delete() {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file = null;
    }

    public String getContents() {
        if (this.file == null) {
            return null;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(this.file));
            String string = this.readString(is, ResourcesPlugin.getEncoding());
            return string;
        }
        catch (FileNotFoundException e) {
            System.out.println("OutputTextFile - read file err: " + e.getMessage());
        }
        finally {
            is = null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readString(InputStream is, String encoding) {
        BufferedReader reader;
        block14: {
            String string;
            if (is == null) {
                return null;
            }
            reader = null;
            try {
                StringBuffer buffer = new StringBuffer();
                char[] part = new char[2048];
                int read = 0;
                reader = new BufferedReader(new InputStreamReader(is, encoding));
                while (true) {
                    if ((read = reader.read(part)) == -1) {
                        string = buffer.toString();
                        if (reader == null) return string;
                        break;
                    }
                    buffer.append(part, 0, read);
                }
            }
            catch (IOException iOException) {
                try {
                    break block14;
                }
                catch (Throwable throwable) {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                reader.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
        if (reader == null) return null;
        try {
            reader.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }
}

