/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IPUniverse;
import org.eclipse.ptp.internal.core.Parent;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPUniverseControl;

public class PMachine
extends Parent
implements IPMachineControl {
    protected String NAME_TAG = "machine ";
    protected String arch = "undefined";

    public PMachine(IPUniverseControl uni, String name, String machineID) {
        super(uni, name, machineID, 11);
        this.setAttribute("Machine ID", machineID);
    }

    public String getMachineId() {
        return (String)this.getAttribute("Machine ID");
    }

    public IPUniverse getUniverse() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPUniverse)) continue;
            return (IPUniverse)((Object)current);
        } while ((current = current.getParent()) != null);
        return null;
    }

    public synchronized IPNode[] getNodes() {
        return this.getCollection().toArray(new IPNodeControl[this.size()]);
    }

    public synchronized IPNode[] getSortedNodes() {
        IPElementControl[] nodes = (IPNodeControl[])this.getNodes();
        this.sort(nodes);
        return nodes;
    }

    public synchronized IPNode findNode(String nodeNumber) {
        IPElementControl element = this.findChild(nodeNumber);
        if (element != null) {
            return (IPNodeControl)element;
        }
        return null;
    }

    public synchronized IPNode findNodeByName(String nname) {
        Collection col = this.getCollection();
        for (Object ob : col) {
            IPNode node;
            if (!(ob instanceof IPNode) || !(node = (IPNode)ob).getName().equals(nname)) continue;
            return node;
        }
        return null;
    }

    public synchronized IPProcess[] getProcesses() {
        ArrayList array = new ArrayList(0);
        IPNodeControl[] nodes = (IPNodeControl[])this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            array.addAll(nodes[i].getCollection());
            ++i;
        }
        return array.toArray(new IPProcessControl[array.size()]);
    }

    public synchronized IPProcess[] getSortedProcesses() {
        IPElementControl[] processes = (IPProcessControl[])this.getProcesses();
        this.sort(processes);
        return processes;
    }

    public void removeAllProcesses() {
        IPProcess[] processes = this.getProcesses();
        int i = 0;
        while (i < processes.length) {
            processes[i].clearOutput();
            ++i;
        }
        this.removeChildren();
    }

    public int totalNodes() {
        return this.size();
    }

    public int totalProcesses() {
        int counter = 0;
        IPNode[] nodes = this.getNodes();
        int i = 0;
        while (i < nodes.length) {
            counter += nodes[i].getNumProcesses();
            ++i;
        }
        return counter;
    }

    public synchronized IPJob[] getJobs() {
        IPProcess[] processes = this.getProcesses();
        ArrayList<IPJob> array = new ArrayList<IPJob>(0);
        int i = 0;
        while (i < processes.length) {
            IPJob job = processes[i].getJob();
            if (job != null && !array.contains(job)) {
                array.add(job);
            }
            ++i;
        }
        return array.toArray(new IPJob[array.size()]);
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public Object getAttribute(String key) {
        return this.getAttribute(2, key);
    }

    public void setAttribute(String key, Object o) {
        this.setAttribute(2, key, o);
    }

    public String[] getAttributeKeys() {
        return this.getAttributeKeys(2);
    }

    public String getName() {
        return this.getElementName();
    }
}

