/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.proxy.event;

import org.eclipse.ptp.core.proxy.event.IProxyEvent;
import org.eclipse.ptp.core.proxy.event.ProxyEvent;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.rtsystem.proxy.event.AbstractProxyRuntimeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeErrorEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeJobStateEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNewJobEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodeAttributeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeNodesEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeOKEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessAttributeEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessOutputEvent;
import org.eclipse.ptp.rtsystem.proxy.event.ProxyRuntimeProcessesEvent;

public class ProxyRuntimeEvent
extends ProxyEvent {
    public static IProxyEvent toEvent(String str) {
        AbstractProxyRuntimeEvent evt = null;
        String[] args = str.split(" ");
        int type = Integer.parseInt(args[0]);
        switch (type) {
            case 200: {
                evt = new ProxyRuntimeOKEvent();
                break;
            }
            case 201: {
                int errCode = Integer.parseInt(args[1]);
                evt = new ProxyRuntimeErrorEvent(errCode, ProxyRuntimeEvent.decodeString(args[2]));
                break;
            }
            case 202: {
                int jobid = Integer.parseInt(args[1]);
                int state = Integer.parseInt(args[2]);
                evt = new ProxyRuntimeJobStateEvent(jobid, state);
                break;
            }
            case 212: {
                int jobid = Integer.parseInt(args[1]);
                evt = new ProxyRuntimeNewJobEvent(jobid);
                break;
            }
            case 204: {
                int nprocs = Integer.parseInt(args[1]);
                evt = new ProxyRuntimeProcessesEvent(nprocs);
                break;
            }
            case 205: {
                String[] kvs;
                int[] dprocs;
                int jobid = Integer.parseInt(args[1]);
                BitList cprocs = ProxyRuntimeEvent.decodeBitSet(args[2]);
                String kv = ProxyRuntimeEvent.decodeString(args[3]);
                int nprocs = Integer.parseInt(args[4]);
                if (nprocs > 0) {
                    dprocs = new int[nprocs];
                    kvs = new String[nprocs];
                    int i = 0;
                    while (i < nprocs) {
                        dprocs[i] = Integer.parseInt(args[2 * i + 5]);
                        kvs[i] = ProxyRuntimeEvent.decodeString(args[2 * i + 6]);
                        ++i;
                    }
                } else {
                    dprocs = null;
                    kvs = null;
                }
                evt = new ProxyRuntimeProcessAttributeEvent(jobid, cprocs, kv, dprocs, kvs);
                break;
            }
            case 207: {
                int nnodes = Integer.parseInt(args[1]);
                evt = new ProxyRuntimeNodesEvent(nnodes);
                break;
            }
            case 208: {
                evt = new ProxyRuntimeNodeAttributeEvent(args);
                break;
            }
            case 214: {
                evt = new ProxyRuntimeNodeChangeEvent(args);
                break;
            }
            case 213: {
                evt = new ProxyRuntimeProcessOutputEvent(args);
                break;
            }
            default: {
                evt = new ProxyRuntimeErrorEvent(11, "Invalid event type");
            }
        }
        return evt;
    }
}

