/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rtsystem.simulation;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.IPNode;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.IProcessListener;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IProcessEvent;
import org.eclipse.ptp.internal.core.OutputTextFile;
import org.eclipse.ptp.internal.core.PElement;
import org.eclipse.ptp.internal.core.PElementInfo;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.internal.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.rtsystem.simulation.SimQueue;
import org.eclipse.ptp.rtsystem.simulation.SimThread;

public class SimProcess
extends Process
implements IPProcess,
IPElementControl,
Comparable {
    InputStream err;
    InputStream in;
    OutputStream out;
    SimThread[] threads;
    SimQueue commands;
    protected HashMap attribs = null;
    protected int ID = -1;
    private PElementInfo elementInfo = null;
    protected String NAME_TAG = "process ";
    private String pid = null;
    private String status = null;
    private String exitCode = null;
    private String signalName = null;
    private boolean isTerminated = false;
    private OutputTextFile outputFile = null;
    protected String outputDirPath = null;
    protected int storeLine = 0;
    private List listeners = new ArrayList();
    protected IPNodeControl node;
    Thread procThread;
    final int numThreads = 1;

    public SimProcess(IPElementControl element, String name, String key, String pid, int taskId, String status, String exitCode, String signalName) {
        this.attribs = new HashMap();
        this.ID = PTPCorePlugin.getDefault().getNewID();
        this.attribs.put("ATTRIB_PARENT", element);
        this.attribs.put("ATTRIB_NAME", name);
        this.attribs.put("ATTRIB_TYPE", new Integer(14));
        System.out.println("NEW PElement - ID = " + this.ID);
        this.pid = pid;
        this.attribs.put("ATTRIB_TASKID", new Integer(taskId));
        this.exitCode = exitCode;
        this.status = status;
        this.setOutputStore();
        this.outputFile = new OutputTextFile(name, this.outputDirPath, this.storeLine);
        Object cmds = null;
        if (cmds == null) {
            this.commands = new SimQueue();
            this.initCommands(this.commands);
        }
        this.threads = new SimThread[1];
        int i = 0;
        while (i < 1) {
            this.threads[i] = new SimThread(this, i, taskId);
            ++i;
        }
        this.err = null;
        this.in = null;
        this.out = null;
        this.procThread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                block4: while (true) {
                    try {
                        block5: while (!SimProcess.this.isTerminated) {
                            int i = 0;
                            while (i < 1) {
                                if (SimProcess.this.threads[i].state == SimProcess.this.threads[i].SUSPENDED) {
                                    Thread.sleep(2000L);
                                    continue block5;
                                }
                                ++i;
                            }
                            ArrayList command = (ArrayList)SimProcess.this.commands.removeItem();
                            String destination = (String)command.get(0);
                            String cmd = (String)command.get(1);
                            String arg = (String)command.get(2);
                            if (!destination.equals("-1")) {
                                SimProcess.this.threads[Integer.parseInt(destination)].runCommand(cmd, arg);
                            } else if (cmd.equals("sleep")) {
                                Thread.sleep(Integer.parseInt(arg));
                            } else if (cmd.equals("exitProcess")) break block4;
                            Thread.sleep(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                int i = 0;
                while (i < 1) {
                    SimProcess.this.threads[i].terminate();
                    ++i;
                }
            }
        };
        this.procThread.start();
    }

    private void setOutputStore() {
        File outputDirectory;
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.outputDirPath = preferences.getString("OUTPUT_DIR");
        this.storeLine = preferences.getInt("STORE_LINE");
        if (this.outputDirPath == null || this.outputDirPath.length() == 0) {
            this.outputDirPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("output").toOSString();
        }
        if (this.storeLine == 0) {
            this.storeLine = 100;
        }
        if (!(outputDirectory = new File(this.outputDirPath)).exists()) {
            outputDirectory.mkdir();
        }
    }

    public IPJob getJob() {
        IPElementControl current = this;
        do {
            if (!(current instanceof IPJob)) continue;
            return (IPJob)((Object)current);
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String getProcessNumber() {
        return "" + this.getTaskId();
    }

    private void fireEvent(IProcessEvent event) {
        for (IProcessListener listener : this.listeners) {
            listener.processEvent(event);
        }
    }

    public void setStatus(String status) {
        this.status = status == null ? "unknown" : status;
    }

    public void setExitCode(String exitCode) {
        this.exitCode = exitCode;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPid() {
        return this.pid;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getSignalName() {
        return this.signalName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void removeProcess() {
        IPNodeControl parent = (IPNodeControl)this.getParent();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public void setTerminated(boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    public void addOutput(String output) {
        this.outputFile.write(String.valueOf(output) + "\n");
    }

    public String getContents() {
        return this.outputFile.getContents();
    }

    public String[] getOutputs() {
        return null;
    }

    public void clearOutput() {
        this.outputFile.delete();
    }

    public void addProcessListener(IProcessListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removerProcessListener(IProcessListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public boolean isAllStop() {
        return this.getStatus().startsWith("exited");
    }

    public void setNode(IPNode node) {
        this.node = (IPNodeControl)node;
        if (node != null) {
            this.node.addChild(this);
        }
    }

    public IPNode getNode() {
        return this.node;
    }

    public int getTaskId() {
        return (Integer)this.attribs.get("ATTRIB_TASKID");
    }

    public void addChild(IPElementControl member) {
        this.getElementInfo().addChild(member);
    }

    public void removeChild(IPElementControl member) {
        this.getElementInfo().removeChild(member);
    }

    public IPElementControl findChild(String key) {
        return this.getElementInfo().findChild(key);
    }

    public void removeChildren() {
        this.getElementInfo().removeChildren();
    }

    public Collection getCollection() {
        PElementInfo info = this.getElementInfo();
        if (info != null) {
            return info.getCollection();
        }
        return Collections.EMPTY_LIST;
    }

    public IPElementControl[] getChildren() {
        PElementInfo info = this.getElementInfo();
        if (info != null) {
            return info.getChildren();
        }
        return new IPElementControl[0];
    }

    public List getChildrenOfType(int type) {
        IPElementControl[] children = this.getChildren();
        int size = children.length;
        ArrayList<PElement> list = new ArrayList<PElement>(size);
        int i = 0;
        while (i < size) {
            PElement elt = (PElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() {
        return this.getElementInfo().hasChildren();
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(IPElementControl[] element, int low, int high) {
        block5: {
            lo = low;
            hi = high;
            if (high <= low) break block5;
            mid = element[(low + high) / 2].getID();
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < high && element[lo].getID() < mid) continue block0;
                    while (hi > low && element[hi].getID() > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(element, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (low < hi) {
                this.quickSort(element, low, hi);
            }
            if (lo < high) {
                this.quickSort(element, lo, high);
            }
        }
    }

    private void swap(IPElementControl[] element, int i, int j) {
        IPElementControl tempElement = element[i];
        element[i] = element[j];
        element[j] = tempElement;
    }

    public void sort(IPElementControl[] element) {
        this.quickSort(element, 0, element.length - 1);
    }

    protected PElementInfo getElementInfo() {
        if (this.elementInfo == null) {
            this.elementInfo = new PElementInfo(this);
        }
        return this.elementInfo;
    }

    public Object getAttribute(String key) {
        return this.getAttribute(5, key);
    }

    public Object getAttribute(int attr, String key) {
        return this.attribs.get(key);
    }

    public String[] getAttributeKeys() {
        return this.getAttributeKeys(5);
    }

    public String[] getAttributeKeys(int attr) {
        return this.attribs.keySet().toArray(new String[0]);
    }

    public String getElementName() {
        return (String)this.attribs.get("ATTRIB_NAME");
    }

    public int getID() {
        return this.ID;
    }

    public String getIDString() {
        return "" + this.ID;
    }

    public void setElementName(String name) {
        this.attribs.put("ATTRIB_NAME", name);
    }

    public IPElementControl getParent() {
        return (IPElementControl)this.attribs.get("ATTRIB_PARENT");
    }

    public void setParent(IPElementControl parent) {
        this.attribs.put("ATTRIB_PARENT", parent);
    }

    public int getElementType() {
        Integer i = (Integer)this.attribs.get("ATTRIB_TYPE");
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setElementType(int type) {
        this.attribs.put("ATTRIB_TYPE", new Integer(type));
    }

    public String toString() {
        return this.getElementName();
    }

    public int size() {
        return this.getElementInfo().size();
    }

    public int compareTo(Object obj) {
        if (obj instanceof IPElementControl) {
            int his_rank;
            int my_rank = this.getID();
            if (my_rank < (his_rank = ((IPElementControl)obj).getID())) {
                return -1;
            }
            if (my_rank == his_rank) {
                return 0;
            }
            if (my_rank > his_rank) {
                return 1;
            }
        }
        return 0;
    }

    public int computeScore(String pageId, Object element) {
        if (element instanceof IPElementControl) {
            return 90;
        }
        return 0;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void destroy() {
        this.setTerminated(true);
    }

    private void initCommands(SimQueue cmds) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(0, "0");
        cmd.add(1, "print");
        cmd.add(2, "ProcessOutput");
        ArrayList<String> cmd3 = new ArrayList<String>();
        cmd3.add(0, "-1");
        cmd3.add(1, "exitProcess");
        cmd3.add(2, "");
        int j = 0;
        while (j < 20) {
            cmds.addItem(cmd);
            ++j;
        }
        cmds.addItem(cmd3);
    }

    public int exitValue() {
        if (this.isTerminated) {
            return 0;
        }
        throw new IllegalThreadStateException();
    }

    public int waitFor() throws InterruptedException {
        try {
            this.procThread.join();
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    public SimThread getThread(int tId) {
        return this.threads[tId];
    }

    public SimThread[] getThreads() {
        return this.threads;
    }

    public int getThreadCount() {
        return this.threads.length;
    }

    public void setAttribute(String key, Object o) {
        this.setAttribute(5, key, o);
    }

    public void setAttribute(int attr, String key, Object o) {
        this.attribs.put(key, o);
    }

    public String getName() {
        return this.getElementName();
    }

    public IPProcess getParentProcess() {
        return (IPProcess)((Object)this.getParent());
    }

    public int getNumChildProcesses() {
        return this.size();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

