/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.actions.CommonActionProviderDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.Priority;

public class CommonActionDescriptorManager {
    private static final CommonActionProviderDescriptor[] NO_DESCRIPTORS = new CommonActionProviderDescriptor[0];
    private static final CommonActionDescriptorManager INSTANCE = new CommonActionDescriptorManager();
    private final Map dependentDescriptors = new LinkedHashMap();
    private final Set overridingDescriptors = new LinkedHashSet();
    private final Map rootDescriptors = new LinkedHashMap();

    private CommonActionDescriptorManager() {
        new ActionProviderRegistry().readRegistry();
    }

    public static CommonActionDescriptorManager getInstance() {
        return INSTANCE;
    }

    protected void addActionDescriptor(CommonActionProviderDescriptor aDescriptor) {
        if (aDescriptor.getDependsOnId() == null) {
            this.rootDescriptors.put(aDescriptor.getDefinedId(), aDescriptor);
        } else {
            this.dependentDescriptors.put(aDescriptor.getDefinedId(), aDescriptor);
        }
        if (aDescriptor.getOverridesId() != null) {
            this.overridingDescriptors.add(aDescriptor);
        }
    }

    protected void computeOrdering() {
        Iterator iter = this.overridingDescriptors.iterator();
        while (iter.hasNext()) {
            CommonActionProviderDescriptor overriddenDescriptor;
            CommonActionProviderDescriptor descriptor = (CommonActionProviderDescriptor)iter.next();
            if (this.rootDescriptors.containsKey(descriptor.getOverridesId())) {
                overriddenDescriptor = (CommonActionProviderDescriptor)this.rootDescriptors.get(descriptor.getOverridesId());
                overriddenDescriptor.addOverridingDescriptor(descriptor);
                continue;
            }
            if (!this.dependentDescriptors.containsKey(descriptor.getOverridesId())) continue;
            overriddenDescriptor = (CommonActionProviderDescriptor)this.dependentDescriptors.get(descriptor.getOverridesId());
            overriddenDescriptor.addOverridingDescriptor(descriptor);
        }
        ArrayList unresolvedDependentDescriptors = new ArrayList(this.dependentDescriptors.values());
        Iterator iter2 = this.dependentDescriptors.values().iterator();
        while (iter2.hasNext()) {
            CommonActionProviderDescriptor dependentDescriptor = (CommonActionProviderDescriptor)iter2.next();
            CommonActionProviderDescriptor requiredDescriptor = (CommonActionProviderDescriptor)this.rootDescriptors.get(dependentDescriptor.getDependsOnId());
            if (requiredDescriptor == null) {
                requiredDescriptor = (CommonActionProviderDescriptor)this.dependentDescriptors.get(dependentDescriptor.getDependsOnId());
            }
            if (requiredDescriptor == null) continue;
            requiredDescriptor.addDependentDescriptor(dependentDescriptor);
            unresolvedDependentDescriptors.remove(dependentDescriptor);
        }
        this.dependentDescriptors.clear();
        if (!unresolvedDependentDescriptors.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("There were unresolved dependencies for action provider extensions to a Common Navigator.\nVerify that the \"dependsOn\" attribute for each <actionProvider /> element is valid.");
            CommonActionProviderDescriptor[] unresolvedDescriptors = unresolvedDependentDescriptors.toArray(new CommonActionProviderDescriptor[unresolvedDependentDescriptors.size()]);
            int i = 0;
            while (i < unresolvedDescriptors.length) {
                errorMessage.append("\nUnresolved dependency specified for actionProvider: ").append(unresolvedDescriptors[i].getDefinedId());
                ++i;
            }
            NavigatorPlugin.log(2, 0, errorMessage.toString(), null);
        }
        unresolvedDependentDescriptors.clear();
    }

    public CommonActionProviderDescriptor[] findRelevantActionDescriptors(INavigatorContentService aContentService, ActionContext aContext) {
        Assert.isNotNull((Object)aContext);
        Object structuredSelection = null;
        structuredSelection = aContext.getSelection() instanceof IStructuredSelection ? (IStructuredSelection)aContext.getSelection() : StructuredSelection.EMPTY;
        HashSet blockedProviders = new HashSet();
        CommonActionProviderDescriptor actionDescriptor = null;
        LinkedHashSet providers = new LinkedHashSet();
        Iterator providerItr = this.rootDescriptors.values().iterator();
        while (providerItr.hasNext()) {
            actionDescriptor = (CommonActionProviderDescriptor)providerItr.next();
            this.addProviderIfRelevant(aContentService, (IStructuredSelection)structuredSelection, actionDescriptor, providers, blockedProviders);
        }
        if (providers.size() > 0) {
            providers.removeAll(blockedProviders);
            return providers.toArray(new CommonActionProviderDescriptor[providers.size()]);
        }
        return NO_DESCRIPTORS;
    }

    private boolean addProviderIfRelevant(INavigatorContentService aContentService, IStructuredSelection structuredSelection, CommonActionProviderDescriptor actionDescriptor, Set providers, Set blockedProviders) {
        if (this.isVisible(aContentService, actionDescriptor) && actionDescriptor.isEnabledFor(structuredSelection)) {
            Iterator iter;
            if (actionDescriptor.hasOverridingDescriptors()) {
                iter = actionDescriptor.overridingDescriptors();
                while (iter.hasNext()) {
                    CommonActionProviderDescriptor descriptor = (CommonActionProviderDescriptor)iter.next();
                    if (!this.addProviderIfRelevant(aContentService, structuredSelection, descriptor, providers, blockedProviders)) continue;
                    while (iter.hasNext()) {
                        blockedProviders.add(iter.next());
                    }
                    return true;
                }
            }
            providers.add(actionDescriptor);
            if (actionDescriptor.hasDependentDescriptors()) {
                iter = actionDescriptor.dependentDescriptors();
                while (iter.hasNext()) {
                    this.addProviderIfRelevant(aContentService, structuredSelection, (CommonActionProviderDescriptor)iter.next(), providers, blockedProviders);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isVisible(INavigatorContentService aContentService, CommonActionProviderDescriptor descriptor) {
        if (descriptor.isNested()) {
            return aContentService.isActive(descriptor.getId()) && aContentService.isVisible(descriptor.getId());
        }
        return aContentService.getViewerDescriptor().isVisibleActionExtension(descriptor.getId());
    }

    private class ActionProviderRegistry
    extends NavigatorContentRegistryReader {
        private ActionProviderRegistry() {
        }

        public void readRegistry() {
            super.readRegistry();
            CommonActionDescriptorManager.this.computeOrdering();
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("actionProvider".equals(anElement.getName())) {
                CommonActionDescriptorManager.this.addActionDescriptor(new CommonActionProviderDescriptor(anElement));
                return true;
            }
            if ("navigatorContent".equals(anElement.getName())) {
                IConfigurationElement[] actionProviders = anElement.getChildren("actionProvider");
                if (actionProviders.length > 0) {
                    IConfigurationElement defaultEnablement = null;
                    IConfigurationElement[] inheritedEnablement = anElement.getChildren("enablement");
                    if (inheritedEnablement.length == 0) {
                        inheritedEnablement = anElement.getChildren("possibleChildren");
                    }
                    defaultEnablement = inheritedEnablement.length == 1 ? inheritedEnablement[0] : null;
                    Priority defaultPriority = Priority.get(anElement.getAttribute("priority"));
                    if (defaultEnablement == null) {
                        NavigatorPlugin.logError(0, "An actionProvider has been defined as the child of a navigatorContent extension that does not specify an <enablement/> or <possibleChildren /> expression. Please review the documenation and correct this error.", null);
                    }
                    int i = 0;
                    while (i < actionProviders.length) {
                        if (defaultEnablement == null) {
                            NavigatorPlugin.logError(0, "Disabling actionProvider: " + actionProviders[i].getAttribute("id"), null);
                        } else {
                            SafeRunner.run((ISafeRunnable)new AddProviderSafeRunner(actionProviders[i], defaultEnablement, defaultPriority, anElement));
                        }
                        ++i;
                    }
                }
                return true;
            }
            return super.readElement(anElement);
        }

        private class AddProviderSafeRunner
        implements ISafeRunnable {
            private IConfigurationElement parentElement;
            private IConfigurationElement defaultEnablement;
            private IConfigurationElement actionProvider;
            private Priority defaultPriority;

            protected AddProviderSafeRunner(IConfigurationElement actionProvider, IConfigurationElement defaultEnablement, Priority defaultPriority, IConfigurationElement parentElement) {
                this.actionProvider = actionProvider;
                this.defaultEnablement = defaultEnablement;
                this.defaultPriority = defaultPriority;
                this.parentElement = parentElement;
            }

            public void run() throws Exception {
                CommonActionDescriptorManager.this.addActionDescriptor(new CommonActionProviderDescriptor(this.actionProvider, this.defaultEnablement, this.defaultPriority, this.parentElement.getAttribute("id"), true));
            }

            public void handleException(Throwable t) {
                NavigatorPlugin.logError(0, "Recovering from error while parsing actionProviders.", t);
            }
        }
    }
}

