/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;

public class MakeTarget
extends PlatformObject
implements IMakeTarget {
    private static final int USE_PROJECT_ENV_SETTING = 3;
    private final MakeTargetManager manager;
    private final IProject project;
    private String name;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    boolean runAllBuidlers = true;
    private String targetBuilderID;
    private IContainer container;
    private int appendEnvironment = 3;
    private boolean appendProjectEnvironment = true;
    private Map buildEnvironment = new HashMap();
    private Map targetAttributes = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    MakeTarget(MakeTargetManager manager, IProject project, String targetBuilderID, String name) throws CoreException {
        this.manager = manager;
        this.project = project;
        this.targetBuilderID = targetBuilderID;
        this.name = name;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(project, manager.getBuilderID(targetBuilderID));
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        this.isDefaultBuildCmd = info.isDefaultBuildCmd();
        this.isStopOnError = info.isStopOnError();
    }

    public IProject getProject() {
        return this.project;
    }

    public void setContainer(IContainer container) {
        this.container = container;
    }

    void setName(String name) {
        this.name = name;
    }

    Map getAttributeMap() {
        return this.targetAttributes;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    public void setStopOnError(boolean stopOnError) throws CoreException {
        this.isStopOnError = stopOnError;
        this.manager.updateTarget(this);
    }

    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    public void setUseDefaultBuildCmd(boolean useDefault) throws CoreException {
        this.isDefaultBuildCmd = useDefault;
        this.manager.updateTarget(this);
    }

    public IPath getBuildCommand() {
        if (this.isDefaultBuildCmd()) {
            try {
                IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
                return info.getBuildCommand();
            }
            catch (CoreException coreException) {}
        }
        String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return new Path(result);
    }

    public void setBuildCommand(IPath command) throws CoreException {
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, command.toString());
    }

    public String getBuildArguments() {
        String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    public void setBuildArguments(String arguments) throws CoreException {
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, arguments);
    }

    public void setBuildTarget(String target) throws CoreException {
        this.setBuildAttribute(IMakeTarget.BUILD_TARGET, target);
    }

    public String getBuildTarget() {
        String result = this.getBuildAttribute(IMakeTarget.BUILD_TARGET, "");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    public void setRunAllBuilders(boolean runAllBuilders) throws CoreException {
        this.runAllBuidlers = runAllBuilders;
        this.manager.updateTarget(this);
    }

    public boolean runAllBuilders() {
        return this.runAllBuidlers;
    }

    public void setBuildAttribute(String name, String value) throws CoreException {
        this.targetAttributes.put(name, value);
        this.manager.updateTarget(this);
    }

    public String getBuildAttribute(String name, String defaultValue) {
        String value = (String)this.targetAttributes.get(name);
        return value != null ? value : defaultValue;
    }

    public IPath getBuildLocation() {
        return this.container.getLocation();
    }

    public void setBuildLocation(IPath location) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String[] getErrorParsers() {
        try {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            return projectInfo.getErrorParsers();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
    }

    public void setErrorParsers(String[] parsers) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public Map getExpandedEnvironment() throws CoreException {
        Map env = null;
        if (this.appendProjectEnvironment()) {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            env = projectInfo.getEnvironment();
        }
        if (env == null) {
            env = this.getEnvironment();
        } else {
            env.putAll(this.getEnvironment());
        }
        HashMap<String, String> envMap = new HashMap<String, String>(env.entrySet().size());
        Iterator iter = env.entrySet().iterator();
        boolean win32 = Platform.getOS().equals("win32");
        while (iter.hasNext()) {
            String value;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            if (win32) {
                key = key.toUpperCase();
            }
            String translated = value = (String)entry.getValue();
            translated = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false);
            envMap.put(key, translated);
        }
        return envMap;
    }

    public boolean appendProjectEnvironment() {
        return this.appendProjectEnvironment;
    }

    public void setAppendProjectEnvironment(boolean append) {
        this.appendProjectEnvironment = append;
    }

    public Map getEnvironment() {
        return this.buildEnvironment;
    }

    public void setEnvironment(Map env) throws CoreException {
        this.buildEnvironment = new HashMap(env);
        this.manager.updateTarget(this);
    }

    public void setAppendEnvironment(boolean append) throws CoreException {
        this.appendEnvironment = append ? 1 : 0;
        this.manager.updateTarget(this);
    }

    public boolean appendEnvironment() {
        return this.appendEnvironment == 3 ? this.getProjectEnvSetting() : this.appendEnvironment == 1;
    }

    private boolean getProjectEnvSetting() {
        try {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            return projectInfo.appendEnvironment();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MakeTarget) {
            MakeTarget other = (MakeTarget)obj;
            return (this.container != null ? this.container.equals((Object)other.getContainer()) : other.getContainer() == null) && this.name.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.container.hashCode() * 17) + this.name != null ? this.name.hashCode() : 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IProgressMonitor monitor) throws CoreException {
        final String builderID = this.manager.getBuilderID(this.targetBuilderID);
        final HashMap infoMap = new HashMap();
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(infoMap, builderID);
        info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        info.setUseDefaultBuildCmd(this.isDefaultBuildCmd());
        info.setStopOnError(this.isStopOnError());
        info.setIncrementalBuildEnable(true);
        info.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, this.getBuildAttribute(IMakeTarget.BUILD_TARGET, ""));
        info.setEnvironment(this.getExpandedEnvironment());
        info.setAppendEnvironment(this.appendEnvironment());
        if (this.container != null) {
            info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_LOCATION, this.container.getFullPath().toString());
        }
        IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), builderID);
        info.setErrorParsers(projectInfo.getErrorParsers());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (MakeTarget.this.runAllBuidlers) {
                    ICommand[] commands = MakeTarget.this.project.getDescription().getBuildSpec();
                    monitor.beginTask("", commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        if (commands[i].getBuilderName().equals(builderID)) {
                            MakeTarget.this.project.build(6, builderID, (Map)infoMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            MakeTarget.this.project.build(6, commands[i].getBuilderName(), commands[i].getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        ++i;
                    }
                    monitor.done();
                } else {
                    MakeTarget.this.project.build(6, builderID, (Map)infoMap, monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, monitor);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getProject();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this.container;
        }
        return super.getAdapter(adapter);
    }
}

