/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class DiscoveredScannerInfoStore {
    private static final QualifiedName dscFileNameProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "discoveredScannerConfigFileName");
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".discoveredScannerInfo";
    public static final String SCD_STORE_VERSION = "scdStore";
    public static final String SI_ELEM = "scannerInfo";
    public static final String COLLECTOR_ELEM = "collector";
    public static final String ID_ATTR = "id";
    private static DiscoveredScannerInfoStore instance;
    private Map fDocumentMap = new HashMap();

    public static DiscoveredScannerInfoStore getInstance() {
        if (instance == null) {
            instance = new DiscoveredScannerInfoStore();
        }
        return instance;
    }

    private DiscoveredScannerInfoStore() {
    }

    public void loadDiscoveredScannerInfoFromState(IProject project, IDiscoveredPathManager.IDiscoveredScannerInfoSerializable serializable) throws CoreException {
        Element rootElem;
        NodeList collectorList;
        NodeList rootList;
        Document document = this.getDocument(project);
        if (document != null && (rootList = document.getElementsByTagName(SI_ELEM)).getLength() > 0 && (collectorList = (rootElem = (Element)rootList.item(0)).getElementsByTagName(COLLECTOR_ELEM)).getLength() > 0) {
            int i = 0;
            while (i < collectorList.getLength()) {
                Element collectorElem = (Element)collectorList.item(i);
                String collectorId = collectorElem.getAttribute(ID_ATTR);
                if (serializable.getCollectorId().equals(collectorId)) {
                    serializable.deserialize(collectorElem);
                    break;
                }
                ++i;
            }
        }
    }

    private Document getDocument(IProject project) throws CoreException {
        Document document = (Document)this.fDocumentMap.get(project);
        if (document == null) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                IPath path = this.getDiscoveredScannerConfigStore(project);
                if (path.toFile().exists()) {
                    FileInputStream file = new FileInputStream(path.toFile());
                    document = builder.parse(file);
                    Node rootElem = document.getFirstChild();
                    if (rootElem.getNodeType() != 7) {
                        this.upgradeDocument(document, project);
                    }
                } else {
                    document = builder.newDocument();
                    ProcessingInstruction pi = document.createProcessingInstruction(SCD_STORE_VERSION, "version=\"2\"");
                    document.appendChild(pi);
                    Element rootElement = document.createElement(SI_ELEM);
                    rootElement.setAttribute(ID_ATTR, CDESCRIPTOR_ID);
                    document.appendChild(rootElement);
                }
                this.fDocumentMap.put(project, document);
            }
            catch (IOException e) {
                MakeCorePlugin.log(e);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                MakeCorePlugin.log(e);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            catch (SAXException e) {
                MakeCorePlugin.log(e);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
        }
        return document;
    }

    private void upgradeDocument(Document document, IProject project) {
        Element rootElem = (Element)document.getElementsByTagName(SI_ELEM).item(0);
        ProcessingInstruction pi = document.createProcessingInstruction(SCD_STORE_VERSION, "version=\"2.0\"");
        document.insertBefore(pi, rootElem);
        Element collectorElem = document.createElement(COLLECTOR_ELEM);
        collectorElem.setAttribute(ID_ATTR, PerProjectSICollector.COLLECTOR_ID);
        Node child = rootElem.getFirstChild();
        while (child != null) {
            collectorElem.appendChild(rootElem.removeChild(child));
            child = rootElem.getFirstChild();
        }
        rootElem.appendChild(collectorElem);
    }

    private void saveDiscoveredScannerInfo(IDiscoveredPathManager.IDiscoveredScannerInfoSerializable serializable, Document doc) {
        NodeList rootList = doc.getElementsByTagName(SI_ELEM);
        if (rootList.getLength() > 0) {
            Element rootElem = (Element)rootList.item(0);
            Element collectorElem = null;
            NodeList collectorList = rootElem.getElementsByTagName(COLLECTOR_ELEM);
            if (collectorList.getLength() > 0) {
                int i = 0;
                while (i < collectorList.getLength()) {
                    Element cElem = (Element)collectorList.item(i);
                    String collectorId = cElem.getAttribute(ID_ATTR);
                    if (serializable.getCollectorId().equals(collectorId)) {
                        Node child = cElem.getFirstChild();
                        while (child != null) {
                            cElem.removeChild(child);
                            child = cElem.getFirstChild();
                        }
                        collectorElem = cElem;
                        break;
                    }
                    ++i;
                }
            }
            if (collectorElem == null) {
                collectorElem = doc.createElement(COLLECTOR_ELEM);
                collectorElem.setAttribute(ID_ATTR, serializable.getCollectorId());
                rootElem.appendChild(collectorElem);
            }
            serializable.serialize(collectorElem);
        }
    }

    public void saveDiscoveredScannerInfoToState(IProject project, IDiscoveredPathManager.IDiscoveredScannerInfoSerializable serializable) throws CoreException {
        Document document = this.getDocument(project);
        try {
            this.saveDiscoveredScannerInfo(serializable, document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            try {
                IPath path = this.getDiscoveredScannerConfigStore(project);
                FileOutputStream file = new FileOutputStream(path.toFile());
                file.write(stream.toByteArray());
                file.close();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
            }
            stream.close();
        }
        catch (TransformerException e) {
            MakeCorePlugin.log(e);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
        }
        catch (IOException e) {
            MakeCorePlugin.log(e);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)e));
        }
    }

    public IPath getDiscoveredScannerConfigStore(IProject project) {
        String fileName = String.valueOf(project.getName()) + ".sc";
        String storedFileName = null;
        try {
            storedFileName = project.getPersistentProperty(dscFileNameProperty);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
        if (storedFileName != null && !storedFileName.equals(fileName)) {
            this.movePluginStateFile(storedFileName, fileName);
        }
        try {
            project.setPersistentProperty(dscFileNameProperty, fileName);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e.getStatus());
        }
        return MakeCorePlugin.getWorkingDirectory().append(fileName);
    }

    public void updateScannerConfigStore(IResourceDelta delta) {
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        int kind = delta.getKind();
                        switch (kind) {
                            case 2: {
                                if ((delta.getFlags() & 0x2000) != 0) {
                                    IPath newPath = delta.getMovedToPath();
                                    IProject newProject = delta.getResource().getWorkspace().getRoot().getProject(newPath.toString());
                                    DiscoveredScannerInfoStore.this.scProjectRenamed(project, newProject);
                                } else {
                                    DiscoveredScannerInfoStore.this.scProjectDeleted(project);
                                }
                                DiscoveredScannerInfoStore.this.fDocumentMap.put(project, null);
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    private void scProjectDeleted(IProject project) {
        String scFileName = String.valueOf(project.getName()) + ".sc";
        this.deletePluginStateFile(scFileName);
    }

    private void deletePluginStateFile(String scFileName) {
        IPath path = MakeCorePlugin.getWorkingDirectory().append(scFileName);
        File file = path.toFile();
        if (file.exists()) {
            file.delete();
        }
    }

    private void scProjectRenamed(IProject project, IProject newProject) {
        String scOldFileName = String.valueOf(project.getName()) + ".sc";
        String scNewFileName = String.valueOf(newProject.getName()) + ".sc";
        this.movePluginStateFile(scOldFileName, scNewFileName);
        try {
            newProject.setPersistentProperty(dscFileNameProperty, scNewFileName);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    private void movePluginStateFile(String oldFileName, String newFileName) {
        IPath oldPath = MakeCorePlugin.getWorkingDirectory().append(oldFileName);
        IPath newPath = MakeCorePlugin.getWorkingDirectory().append(newFileName);
        File oldFile = oldPath.toFile();
        File newFile = newPath.toFile();
        if (oldFile.exists()) {
            oldFile.renameTo(newFile);
        }
    }
}

