/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class MapEntrySourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(CDebugCorePlugin.getUniqueIdentifier()) + ".containerType.mapEntry";
    private IPath fLocalPath;
    private IPath fBackendPath;

    public MapEntrySourceContainer() {
        this.fBackendPath = Path.EMPTY;
        this.fLocalPath = Path.EMPTY;
    }

    public MapEntrySourceContainer(IPath backend, IPath local) {
        this.fBackendPath = backend;
        this.fLocalPath = local;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        Path path = new Path(name);
        if (this.getBackendPath().isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(this.getBackendPath().segmentCount());
            path = this.getLocalPath().append((IPath)path);
            IFile[] wsFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < wsFiles.length) {
                if (wsFiles[j].exists()) {
                    list.add(wsFiles[j]);
                    if (!this.isFindDuplicates()) break;
                }
                ++j;
            }
            if (list.size() > 0) {
                return list.toArray();
            }
            File file = path.toFile();
            if (file.exists() && file.isFile()) {
                return new Object[]{new LocalFileStorage(file)};
            }
        }
        return EMPTY;
    }

    public String getName() {
        return MessageFormat.format("{0} - {1}", this.getBackendPath().toOSString(), this.getLocalPath().toOSString());
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public IPath getLocalPath() {
        return this.fLocalPath;
    }

    public IPath getBackendPath() {
        return this.fBackendPath;
    }

    public void setLocalPath(IPath local) {
        this.fLocalPath = local;
    }

    public void setBackendPath(IPath backend) {
        this.fBackendPath = backend;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapEntrySourceContainer)) {
            return false;
        }
        MapEntrySourceContainer entry = (MapEntrySourceContainer)((Object)o);
        return entry.getBackendPath().equals((Object)this.getBackendPath()) && entry.getLocalPath().equals((Object)this.getLocalPath());
    }

    public MapEntrySourceContainer copy() {
        return new MapEntrySourceContainer(this.fBackendPath, this.fLocalPath);
    }
}

