/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IBuildPathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.gnu.ui.GnuUIPlugin;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;

public class CygwinPathResolver
implements IBuildPathResolver {
    static final String TOOL = "/cygpath -w -p ";
    static final char BS = '\\';
    static final char SLASH = '/';
    static final String PROPERTY_OS_NAME = "os.name";
    static final String PROPERTY_OS_VALUE = "windows";
    static final String ARG0 = "regedit";
    static final String ARG1 = "/ea";
    static final String OUTFILE = "result.txt";
    static final String SP = " ";
    static final String QUOT = "\"";
    static final String REGISTRY_KEY = "\\SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2";
    static final String[] REGISTRY_ROOTS = new String[]{"\"HKEY_CURRENT_USER", "\"HKEY_LOCAL_MACHINE"};
    static final String REGISTRY_BINS = "/usr/bin";
    static final String CYGPREF_NAME = "cygdrive prefix";
    static final String PATH_NAME = "native";
    static final String REG_SZ = "REG_SZ";
    static final String BINPATTERN = "/usr/bin";
    static final String ETCPATTERN = "/etc";
    static final String ROOTPATTERN = "/";
    static final String DELIMITER_UNIX = ":";
    static final String DELIMITER_WIN = ";";
    static final String GCC_VERSION_CMD = "gcc --version";
    static final String MINGW_SPECIAL = "mingw ";
    static final String CYGWIN_SPECIAL = "cygwin ";
    static boolean checked = false;
    static String binCygwin = null;
    static String rootCygwin = null;
    static String etcCygwin = null;

    public String[] resolveBuildPaths(int pathType, String variableName, String variableValue, IConfiguration configuration) {
        if (!CygwinPathResolver.isWindows()) {
            return variableValue.split(DELIMITER_UNIX);
        }
        if (CygwinPathResolver.isMinGW(configuration)) {
            return variableValue.split(DELIMITER_WIN);
        }
        String[] result = variableValue.split(DELIMITER_UNIX);
        String exePath = CygwinPathResolver.getBinPath();
        if (exePath == null) {
            return result;
        }
        File file = new File(exePath);
        if (!file.exists() || !file.isDirectory()) {
            return result;
        }
        String s = String.valueOf(exePath) + TOOL + variableValue;
        String[] lines = CygwinPathResolver.exec(s, configuration);
        if (lines != null && lines.length > 0) {
            result = lines[0].replace('\\', '/').split(DELIMITER_WIN);
        }
        return result;
    }

    public static String getEtcPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return etcCygwin;
    }

    public static String getBinPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return binCygwin;
    }

    public static String getRootPath() {
        if (!checked) {
            CygwinPathResolver.checkRegistry();
        }
        return rootCygwin;
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void checkRegistry() {
        if (checked) {
            return;
        }
        try {
            etcCygwin = null;
            binCygwin = null;
            rootCygwin = null;
            if (!CygwinPathResolver.isWindows()) {
                Object var8 = null;
                checked = true;
                return;
            }
            int i = 0;
            while (i < REGISTRY_ROOTS.length) {
                block16: {
                    IPath toSave = GnuUIPlugin.getDefault().getStateLocation();
                    toSave = toSave.addTrailingSeparator().append(OUTFILE);
                    String[] args = new String[]{ARG0, ARG1, toSave.toOSString(), String.valueOf(REGISTRY_ROOTS[i]) + REGISTRY_KEY + QUOT};
                    try {
                        File f = new File(toSave.toOSString());
                        f.delete();
                        if (ProcessFactory.getFactory().exec(args).waitFor() != 0 || !f.exists() || !f.canRead()) break block16;
                        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                        ArrayList<String> ls = new ArrayList<String>(1);
                        while (true) {
                            String s;
                            if ((s = r.readLine()) == null) {
                                r.close();
                                f.delete();
                                String[] aus = ls.toArray(new String[0]);
                                if (etcCygwin == null) {
                                    etcCygwin = CygwinPathResolver.getDir(aus, ETCPATTERN);
                                }
                                if (binCygwin == null) {
                                    binCygwin = CygwinPathResolver.getDir(aus, "/usr/bin");
                                }
                                if (rootCygwin == null) {
                                    rootCygwin = CygwinPathResolver.getDir(aus, ROOTPATTERN);
                                }
                                break;
                            }
                            ls.add(s);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (SecurityException securityException) {}
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_1 = null;
            checked = true;
            throw throwable;
        }
        {
            Object var8_2 = null;
            checked = true;
            return;
        }
    }

    private static String getDir(String[] ls, String pattern) {
        String tail = "";
        while (pattern.length() > 0) {
            int pos;
            boolean search = false;
            int i = 0;
            while (i < ls.length) {
                int pos2 = 0;
                if (ls[i].lastIndexOf(REGISTRY_KEY) > 0) {
                    search = ls[i].endsWith(String.valueOf(pattern) + "]");
                } else if (search && (pos2 = ls[i].lastIndexOf(PATH_NAME)) > 0) {
                    String s = ls[i].substring(pos2 + PATH_NAME.length() + 3).trim();
                    s = String.valueOf(s.substring(0, s.length() - 1)) + tail;
                    return s.replaceAll("\\\\+", ROOTPATTERN);
                }
                ++i;
            }
            if (pattern.equals(ROOTPATTERN) || (pos = pattern.lastIndexOf(47)) < 0) break;
            tail = String.valueOf(pattern.substring(pos, pattern.length())) + tail;
            pattern = pos == 0 ? ROOTPATTERN : pattern.substring(0, pos);
        }
        return null;
    }

    private static String[] exec(String cmd, IConfiguration cfg) {
        try {
            IBuildEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables((Object)cfg, true, true);
            String[] env = new String[vars.length];
            int i = 0;
            while (i < env.length) {
                env[i] = String.valueOf(vars[i].getName()) + "=";
                String value = vars[i].getValue();
                if (value != null) {
                    int n = i;
                    env[n] = String.valueOf(env[n]) + value;
                }
                ++i;
            }
            Process proc = ProcessFactory.getFactory().exec(cmd.split(SP), env);
            if (proc != null) {
                String s;
                InputStream ein = proc.getInputStream();
                BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                ArrayList<String> ls = new ArrayList<String>(10);
                while ((s = d1.readLine()) != null) {
                    ls.add(s);
                }
                ein.close();
                return ls.toArray(new String[0]);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static boolean isMinGW(IConfiguration cfg) {
        String[] versionInfo = CygwinPathResolver.exec(GCC_VERSION_CMD, cfg);
        if (versionInfo != null) {
            int i = 0;
            while (i < versionInfo.length) {
                if (versionInfo[i].indexOf(MINGW_SPECIAL) != -1) {
                    return true;
                }
                if (versionInfo[i].indexOf(CYGWIN_SPECIAL) != -1) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }
}

