/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.enums;

import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;

public abstract class UserEventValueType {
    private final String name;
    public static final UserEventValueType NUMSAMPLES = new UserEventValueType("Number of Samples"){

        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getNumSamples(n);
        }

        public double getMaxValue(UserEvent userEvent) {
            return userEvent.getMaxUserEventNumberValue();
        }
    };
    public static final UserEventValueType MAX = new UserEventValueType("Max Value"){

        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMaxValue(n);
        }

        public double getMaxValue(UserEvent userEvent) {
            return userEvent.getMaxUserEventMaxValue();
        }
    };
    public static final UserEventValueType MIN = new UserEventValueType("Min Value"){

        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMinValue(n);
        }

        public double getMaxValue(UserEvent userEvent) {
            return userEvent.getMaxUserEventMinValue();
        }
    };
    public static final UserEventValueType MEAN = new UserEventValueType("Mean Value"){

        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getMeanValue(n);
        }

        public double getMaxValue(UserEvent userEvent) {
            return userEvent.getMaxUserEventMeanValue();
        }
    };
    public static final UserEventValueType STDDEV = new UserEventValueType("Standard Deviation"){

        public double getValue(UserEventProfile userEventProfile, int n) {
            return userEventProfile.getStdDev(n);
        }

        public double getMaxValue(UserEvent userEvent) {
            return userEvent.getMaxUserEventStdDev();
        }
    };

    private UserEventValueType(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public double getValue(UserEventProfile userEventProfile) {
        return this.getValue(userEventProfile, -1);
    }

    public abstract double getValue(UserEventProfile var1, int var2);
}

