/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class PDOMSearchElementQuery
extends PDOMSearchQuery {
    private ISourceReference element;

    public PDOMSearchElementQuery(ICElement[] scope, ISourceReference element, int flags) {
        super(scope, flags);
        this.element = element;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            ISourceRange range = this.element.getSourceRange();
            ITranslationUnit tu = this.element.getTranslationUnit();
            ILanguage language = tu.getLanguage();
            IASTTranslationUnit ast = language.getASTTranslationUnit(tu, 3);
            IASTName[] names = language.getSelectedNames(ast, range.getIdStartPos(), range.getIdLength());
            int i = 0;
            while (i < names.length) {
                IBinding binding = names[i].resolveBinding();
                this.createMatches(language, binding);
                ++i;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public String getLabel() {
        if (this.element instanceof ICElement) {
            return String.valueOf(super.getLabel()) + " " + ((ICElement)this.element).getElementName();
        }
        return String.valueOf(super.getLabel()) + " something.";
    }
}

