/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;

public class Strings {
    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Strings.isLineDelimiterChar(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static String removeNewLine(String message) {
        StringBuffer result = new StringBuffer();
        int current = 0;
        int index = message.indexOf(10, 0);
        while (index != -1) {
            result.append(message.substring(current, index));
            if (current < index && index != 0) {
                result.append(' ');
            }
            current = index + 1;
            index = message.indexOf(10, current);
        }
        result.append(message.substring(current));
        return result.toString();
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (!Strings.isIndentChar(c)) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String trimTrailingTabsAndSpaces(String line) {
        int size;
        int end = size = line.length();
        int i = size - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (!Strings.isIndentChar(c)) break;
            end = i--;
        }
        if (end == size) {
            return line;
        }
        if (end == 0) {
            return "";
        }
        return line.substring(0, end);
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
            } else if (Strings.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++result;
                    blanks = 0;
                }
            } else {
                return result;
            }
            ++i;
        }
        return result;
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth) {
        if (line == null || indentsToRemove <= 0) {
            return line;
        }
        int start = 0;
        int indents = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++indents;
                blanks = 0;
            } else if (Strings.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++indents;
                    blanks = 0;
                }
            } else {
                start = i + 1;
                break;
            }
            if (indents == indentsToRemove) {
                start = i + 1;
                break;
            }
            ++i;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String trimIndents(String s, int tabWidth) {
        int indent = Strings.computeIndent(s, tabWidth);
        if (indent == 0) {
            return s;
        }
        return Strings.trimIndent(s, indent, tabWidth);
    }

    public static void trimIndentation(String[] lines, int tabWidth) {
        Strings.trimIndentation(lines, tabWidth, true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, boolean considerFirstLine) {
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndent(line, tabWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth) : ((indent = Strings.computeIndent(line = lines[i], tabWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String getIndentString(String line, int tabWidth) {
        int size = line.length();
        int end = 0;
        int blanks = 0;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                end = i + 1;
                blanks = 0;
            } else {
                if (!Strings.isIndentChar(c)) break;
                if (++blanks == tabWidth) {
                    end = i + 1;
                    blanks = 0;
                }
            }
            ++i;
        }
        if (end == 0) {
            return "";
        }
        if (end == size) {
            return line;
        }
        return line.substring(0, end);
    }

    public static String[] removeTrailingEmptyLines(String[] sourceLines) {
        int lastNonEmpty = Strings.findLastNonEmptyLineIndex(sourceLines);
        String[] result = new String[lastNonEmpty + 1];
        int i = 0;
        while (i < result.length) {
            result[i] = sourceLines[i];
            ++i;
        }
        return result;
    }

    private static int findLastNonEmptyLineIndex(String[] sourceLines) {
        int i = sourceLines.length - 1;
        while (i >= 0) {
            if (!sourceLines[i].trim().equals("")) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static String changeIndent(String code, int codeIndentLevel, int tabWidth, String newIndent, String lineDelim) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(code);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return code;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < nLines) {
                IRegion region = tracker.getLineInformation(i);
                int start = region.getOffset();
                int end = start + region.getLength();
                String line = code.substring(start, end);
                if (i == 0) {
                    buf.append(line);
                } else {
                    buf.append(lineDelim);
                    buf.append(newIndent);
                    buf.append(Strings.trimIndent(line, codeIndentLevel, tabWidth));
                }
                ++i;
            }
            return buf.toString();
        }
        catch (BadLocationException badLocationException) {
            return code;
        }
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean equals(String s, char[] c) {
        if (s.length() != c.length) {
            return false;
        }
        int i = c.length;
        while (--i >= 0) {
            if (s.charAt(i) == c[i]) continue;
            return false;
        }
        return true;
    }

    public static String createIndentString(int indentLevel) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            result.append('\t');
            ++i;
        }
        return result.toString();
    }
}

