/****************************************************************************
 *			Tuning and Analysis Utilities
 *			http://www.cs.uoregon.edu/research/paracomp/tau
 ****************************************************************************
 * Copyright (c) 1997-2006
 *    Department of Computer and Information Science, University of Oregon
 *    Advanced Computing Laboratory, Los Alamos National Laboratory
 *    Research Center Juelich, ZAM Germany	
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Wyatt Spear - initial API and implementation
 ****************************************************************************/
package org.eclipse.ptp.tau.toolopts;

import java.util.ArrayList;

/**
 * Encapsulates all relevant attributes of a performance tool
 * including compilers, analysis tools, TODO runtime prefixes, 
 * build arguments and TODO environment settings
 * @author wspear
 *
 */
public class PerformanceTool {
	public String toolID=null;
	public String toolName=null;
	
	public boolean recompile=false;
	public boolean replaceCompiler=false;
	public String ccCompiler=null;
	public String cxxCompiler=null;
	public String f90Compiler=null;
	
	public String pathFinder=null;
	public String queryText=null;
	public String queryMessage=null;
	
	public boolean prependExecution=false;
	public String prependWith=null;
	public String prependArgs=null;
	
	public ToolPane[] toolPanes=null;
	
	public ArrayList analysisCommands=null;
	
}
