/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.photran.internal.core.lexer.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.lexer.LineInputStream;

public final class FortranPreprocessor
extends InputStream {
    private static final Pattern INCLUDE_LINE = Pattern.compile("[ \t]*[Ii][Nn][Cc][Ll][Uu][Dd][Ee][ \t]+[\"']([^\r\n\"]*)[\"'][ \t]*(![^\r\n]*)?[\r\n]*");
    private static final int INCLUDE_LINE_CAPTURING_GROUP_OF_FILENAME = 1;
    private IncludeLoaderCallback callback;
    private Stack streamStack;
    private int offset = 0;
    private int line = 1;
    private LinkedList directivesInTopLevelFile;
    private ArrayList directiveStartOffsets;
    private LinkedList fileNames;
    private ArrayList fileStartOffsets;
    private ArrayList fileStartOffsetAdjustments;
    private ArrayList fileStartLines;
    private ArrayList fileStartLineAdjustments;

    public FortranPreprocessor(InputStream readFrom, String filename, IncludeLoaderCallback callback) throws IOException {
        this.callback = callback;
        this.streamStack = new Stack();
        this.streamStack.push(new LineInputStream(readFrom, filename));
        this.directivesInTopLevelFile = new LinkedList();
        this.directivesInTopLevelFile.add(null);
        this.directiveStartOffsets = new ArrayList();
        this.directiveStartOffsets.add(new Integer(0));
        this.fileNames = new LinkedList();
        this.fileNames.add(filename);
        this.fileStartOffsets = new ArrayList();
        this.fileStartOffsets.add(new Integer(0));
        this.fileStartOffsetAdjustments = new ArrayList();
        this.fileStartOffsetAdjustments.add(new Integer(0));
        this.fileStartLines = new ArrayList();
        this.fileStartLines.add(new Integer(1));
        this.fileStartLineAdjustments = new ArrayList();
        this.fileStartLineAdjustments.add(new Integer(0));
    }

    private LineInputStream currentStream() {
        return (LineInputStream)this.streamStack.peek();
    }

    public String getFilenameAtOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            if ((Integer)this.fileStartOffsets.get(i) <= offset) {
                return (String)this.fileNames.get(i);
            }
            --i;
        }
        return null;
    }

    public int getStartOffsetOfFileContainingStreamOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            int fileStartOffset = (Integer)this.fileStartOffsets.get(i);
            if (fileStartOffset <= offset) {
                return fileStartOffset;
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public String getDirectiveAtOffset(int offset) {
        int i = this.directiveStartOffsets.size() - 1;
        while (i >= 0) {
            if ((Integer)this.directiveStartOffsets.get(i) <= offset) {
                return (String)this.directivesInTopLevelFile.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int getFileLineFromStreamLine(int line) {
        int i = this.fileStartLines.size() - 1;
        while (i >= 0) {
            if ((Integer)this.fileStartLines.get(i) <= line) {
                return line - (Integer)this.fileStartLineAdjustments.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int getFileOffsetFromStreamOffset(int offset) {
        int i = this.fileStartOffsets.size() - 1;
        while (i >= 0) {
            if ((Integer)this.fileStartOffsets.get(i) <= offset) {
                return offset - (Integer)this.fileStartOffsetAdjustments.get(i);
            }
            --i;
        }
        throw new IllegalArgumentException();
    }

    public int read() throws IOException {
        int result;
        if (this.currentStream().atBOL()) {
            this.checkForInclude();
        }
        if (this.currentStream().atEOF()) {
            this.finishInclude();
        }
        if ((result = this.currentStream().read()) >= 0) {
            ++this.offset;
            if (result == 10) {
                ++this.line;
            }
        }
        return result;
    }

    private boolean inTopLevelFile() {
        return this.streamStack.size() <= 1;
    }

    private void checkForInclude() throws FileNotFoundException, IOException {
        Matcher m = INCLUDE_LINE.matcher(this.currentStream());
        if (m.matches()) {
            LineInputStream origStream = this.currentStream();
            String includeLine = origStream.currentLine();
            String fileToInclude = m.group(1);
            InputStream newStream = this.findIncludedFile(fileToInclude);
            if (newStream != null) {
                if (this.inTopLevelFile()) {
                    this.directivesInTopLevelFile.add(includeLine);
                    this.directiveStartOffsets.add(new Integer(this.offset));
                }
                origStream.setRestartOffset(this.offset + includeLine.length());
                origStream.setRestartLine(this.line + 1);
                this.streamStack.push(new LineInputStream(newStream, fileToInclude, this.offset, this.line));
                this.fileNames.add(fileToInclude);
                this.fileStartOffsets.add(new Integer(this.offset));
                this.fileStartOffsetAdjustments.add(new Integer(this.getOffsetAdjustment(0)));
                this.fileStartLines.add(new Integer(this.line));
                this.fileStartLineAdjustments.add(new Integer(this.getLineAdjustment(1)));
                origStream.advanceToNextLine();
            }
        }
    }

    private InputStream findIncludedFile(String fileToInclude) throws IOException {
        try {
            return this.callback.getIncludedFileAsStream(fileToInclude);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String msg = this.callback.onUnableToLoad("Unable to locate INCLUDE file \"" + fileToInclude + "\"", fileToInclude);
            if (msg == null) {
                return null;
            }
            throw new FileNotFoundException(msg);
        }
    }

    private void finishInclude() {
        if (!this.inTopLevelFile()) {
            this.streamStack.pop();
            this.fileNames.add(this.currentStream().getFilename());
            this.fileStartOffsets.add(new Integer(this.offset));
            this.fileStartOffsetAdjustments.add(new Integer(this.getOffsetAdjustment(this.currentStream().getRestartOffset())));
            this.fileStartLines.add(new Integer(this.line));
            this.fileStartLineAdjustments.add(new Integer(this.getLineAdjustment(this.currentStream().getRestartLine())));
        }
        if (this.inTopLevelFile()) {
            this.directivesInTopLevelFile.add(null);
            this.directiveStartOffsets.add(new Integer(this.offset));
        }
    }

    private int getOffsetAdjustment(int desiredOffset) {
        return this.offset - desiredOffset;
    }

    private int getLineAdjustment(int desiredLine) {
        return this.line - desiredLine;
    }
}

