/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.photran.internal.core.lexer.FortranPreprocessor;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.lexer.LineAppendingInputStream;
import org.eclipse.photran.internal.core.lexer.Token;

public class PreprocessingFreeFormLexerPhase1
extends FreeFormLexerPhase1 {
    private FortranPreprocessor preprocessor;
    private String lastDirective;

    public PreprocessingFreeFormLexerPhase1(InputStream in, String filename, IncludeLoaderCallback callback) throws IOException {
        this(new FortranPreprocessor(new LineAppendingInputStream(in), filename, callback));
    }

    private PreprocessingFreeFormLexerPhase1(FortranPreprocessor preprocessor) {
        super(preprocessor);
        this.preprocessor = preprocessor;
        this.lastDirective = null;
    }

    public Token yylex() throws IOException, Exception {
        Token token = super.yylex();
        String thisDirective = this.preprocessor.getDirectiveAtOffset(this.lastTokenStreamOffset);
        if (thisDirective != null && this.lastDirective == null) {
            this.adjustWhiteBeforeAtIncludeStart(token);
        } else if (thisDirective == null && this.lastDirective != null) {
            this.adjustWhiteBeforeAtIncludeEnd(token);
        }
        token.setPreprocessorDirective(thisDirective);
        this.lastDirective = thisDirective;
        this.lastTokenFileOffset = this.preprocessor.getFileOffsetFromStreamOffset(this.lastTokenStreamOffset);
        this.lastTokenLine = this.preprocessor.getFileLineFromStreamLine(this.lastTokenLine);
        return token;
    }

    private void adjustWhiteBeforeAtIncludeStart(Token token) {
        int fileStartOffset = this.preprocessor.getStartOffsetOfFileContainingStreamOffset(this.lastTokenStreamOffset);
        int tokenTextStartOffset = this.lastTokenStreamOffset;
        String whiteBefore = token.getWhiteBefore();
        int charsFromIncludeFile = tokenTextStartOffset - fileStartOffset;
        if (charsFromIncludeFile > 0) {
            token.setWhiteBefore(whiteBefore.substring(0, whiteBefore.length() - charsFromIncludeFile));
        }
    }

    private void adjustWhiteBeforeAtIncludeEnd(Token token) {
        int fileStartOffset = this.preprocessor.getStartOffsetOfFileContainingStreamOffset(this.lastTokenStreamOffset);
        int tokenTextStartOffset = this.lastTokenStreamOffset;
        String whiteBefore = token.getWhiteBefore();
        int charsFromRealFile = tokenTextStartOffset - fileStartOffset;
        int charsToTrim = whiteBefore.length() - charsFromRealFile;
        token.setWhiteBefore(whiteBefore.substring(charsToTrim));
    }

    public void yypushback(int number) {
        throw new UnsupportedOperationException();
    }
}

