/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.refactoring.ASTManager;

public abstract class ASTNameVisitor
extends ASTVisitor {
    private int fOffset = -1;
    private String fFileName;

    public ASTNameVisitor(String fileName) {
        this(fileName, -1);
    }

    public ASTNameVisitor(String fileName, int offset) {
        this.fFileName = fileName;
        this.fOffset = offset;
        this.shouldVisitNames = true;
    }

    protected abstract int visitName(IASTName var1);

    public final int visit(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qn = (ICPPASTQualifiedName)name;
            IASTName[] names = qn.getNames();
            boolean visited = false;
            int i = 0;
            while (i < names.length) {
                if (this.checkLocation((IASTNode)names[i])) {
                    if (this.visitName(names[i]) == 2) {
                        return 2;
                    }
                    visited = true;
                }
                ++i;
            }
            if (!visited && names.length > 0 && this.checkLocation((IASTNode)name)) {
                return this.visitName(names[names.length - 1]);
            }
        } else if (this.checkLocation((IASTNode)name)) {
            return this.visitName(name);
        }
        return 3;
    }

    private boolean checkLocation(IASTNode node) {
        if (this.fFileName == null) {
            return true;
        }
        if (!this.fFileName.equals(node.getContainingFilename())) {
            return false;
        }
        IASTNodeLocation[] locs = node.getNodeLocations();
        if (locs == null || locs.length != 1) {
            return false;
        }
        if (this.fOffset == -1) {
            return true;
        }
        IASTFileLocation floc = locs[0].asFileLocation();
        int off = floc.getNodeOffset();
        int len = floc.getNodeLength();
        if (locs[0] instanceof IASTMacroExpansion && node instanceof IASTName) {
            IASTName name = (IASTName)node;
            off = ASTManager.backrelateNameToMacroCallArgument(name, (IASTMacroExpansion)locs[0]);
            len = name.toCharArray().length;
        }
        return off <= this.fOffset && this.fOffset < off + len;
    }
}

