/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IParserConfiguration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameRefactoring;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.internal.refactoring.TextSearchWrapper;
import org.eclipse.cdt.internal.refactoring.ui.CRenameRefactoringWizard;
import org.eclipse.cdt.refactoring.ICRefactoringArgument;
import org.eclipse.cdt.refactoring.ICRefactoringSearch;
import org.eclipse.cdt.refactoring.IParserConfigurationProvider;
import org.eclipse.cdt.refactoring.IPositionConsumer;
import org.eclipse.cdt.refactoring.IPositionProvider;
import org.eclipse.cdt.refactoring.actions.CElementPositionAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRefactory {
    public static final int OPTION_ASK_SCOPE = 1;
    public static final int OPTION_IN_COMMENT = 2;
    public static final int OPTION_IN_STRING_LITERAL = 4;
    public static final int OPTION_IN_INCLUDE_DIRECTIVE = 8;
    public static final int OPTION_IN_MACRO_DEFINITION = 16;
    public static final int OPTION_IN_PREPROCESSOR_DIRECTIVE = 32;
    public static final int OPTION_IN_INACTIVE_CODE = 64;
    public static final int OPTION_IN_CODE = 128;
    public static final int ARGUMENT_UNKNOWN = 0;
    public static final int ARGUMENT_LOCAL_VAR = 1;
    public static final int ARGUMENT_PARAMETER = 2;
    public static final int ARGUMENT_FILE_LOCAL_VAR = 3;
    public static final int ARGUMENT_GLOBAL_VAR = 4;
    public static final int ARGUMENT_FIELD = 5;
    public static final int ARGUMENT_FILE_LOCAL_FUNCTION = 6;
    public static final int ARGUMENT_GLOBAL_FUNCTION = 7;
    public static final int ARGUMENT_VIRTUAL_METHOD = 8;
    public static final int ARGUMENT_NON_VIRTUAL_METHOD = 9;
    public static final int ARGUMENT_TYPE = 10;
    public static final int ARGUMENT_MACRO = 11;
    public static final int ARGUMENT_INCLUDE_DIRECTIVE = 12;
    public static final int ARGUMENT_ENUMERATOR = 13;
    public static final int ARGUMENT_CLASS_TYPE = 14;
    public static final int ARGUMENT_NAMESPACE = 15;
    private static CRefactory sInstance = new CRefactory();
    private ICRefactoringSearch fTextSearch;
    private String[] fAffectedProjectNatures;
    private IParserConfigurationProvider[] fParserConfigurationProviders = new IParserConfigurationProvider[0];
    private IPositionProvider[] fPositionAdapters = new IPositionProvider[0];

    public static CRefactory getInstance() {
        return sInstance;
    }

    public static ICRefactoringArgument createArgument(ITextEditor editor, ITextSelection selection) {
        return new CRefactoringArgument(editor, selection);
    }

    public static ICRefactoringArgument createArgument(IFile file, int offset, String text) {
        return new CRefactoringArgument(file, offset, text);
    }

    private CRefactory() {
        this.fAffectedProjectNatures = new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
        this.addPositionProvider(new CElementPositionAdapter());
    }

    public void rename(Shell shell, ICRefactoringArgument arg) {
        if (!IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (boolean)false)) {
            return;
        }
        CRefactoringArgument iarg = (CRefactoringArgument)arg;
        CRenameRefactoring r = new CRenameRefactoring(new CRenameProcessor(this, iarg));
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)new CRenameRefactoringWizard(r));
        try {
            op.run(shell, Messages.getString("CRefactory.title.rename"));
        }
        catch (InterruptedException interruptedException) {}
    }

    public ICRefactoringSearch getTextSearch() {
        if (this.fTextSearch == null) {
            return new TextSearchWrapper();
        }
        return this.fTextSearch;
    }

    public void setTextSearch(ICRefactoringSearch txtSearch) {
        this.fTextSearch = txtSearch;
    }

    public String[] getCCppPatterns() {
        IContentType[] cts = Platform.getContentTypeManager().getAllContentTypes();
        HashSet<String> all = new HashSet<String>();
        int i = 0;
        while (i < cts.length) {
            IContentType type = cts[i];
            boolean useit = false;
            while (!useit && type != null) {
                String id = type.getId();
                if (id.equals("org.eclipse.cdt.core.cHeader") || id.equals("org.eclipse.cdt.core.cSource") || id.equals("org.eclipse.cdt.core.cxxHeader") || id.equals("org.eclipse.cdt.core.cxxSource")) {
                    useit = true;
                    continue;
                }
                type = type.getBaseType();
            }
            if (useit) {
                String[] exts = type.getFileSpecs(8);
                all.addAll(Arrays.asList(exts));
            }
            ++i;
        }
        String[] result = new String[all.size()];
        Iterator it = all.iterator();
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = "*." + (String)it.next();
            ++i2;
        }
        return result;
    }

    public IASTTranslationUnit getTranslationUnit(IFile sourceFile, RefactoringStatus status) {
        IParserConfiguration pcfg = null;
        SavedCodeReaderFactory codeReader = SavedCodeReaderFactory.getInstance();
        int i = 0;
        while (i < this.fParserConfigurationProviders.length) {
            IParserConfigurationProvider pcp = this.fParserConfigurationProviders[i];
            pcfg = pcp.getParserConfiguration(sourceFile);
            if (pcfg != null) break;
            ++i;
        }
        try {
            return CDOM.getInstance().getTranslationUnit(sourceFile, (ICodeReaderFactory)codeReader, pcfg);
        }
        catch (IASTServiceProvider.UnsupportedDialectException e) {
            status.addError(e.getMessage());
            return null;
        }
    }

    public void addAffectedProjectNatures(String nature) {
        HashSet<String> natures = new HashSet<String>();
        natures.addAll(Arrays.asList(this.fAffectedProjectNatures));
        natures.add(nature);
        this.fAffectedProjectNatures = natures.toArray(new String[natures.size()]);
    }

    public String[] getAffectedProjectNatures() {
        return this.fAffectedProjectNatures;
    }

    public void addEditorDefiningExtension(String editorID) {
    }

    public void addParserConfigurationProvider(IParserConfigurationProvider pcp) {
        HashSet<IParserConfigurationProvider> now = new HashSet<IParserConfigurationProvider>();
        now.addAll(Arrays.asList(this.fParserConfigurationProviders));
        now.add(pcp);
        this.fParserConfigurationProviders = now.toArray(new IParserConfigurationProvider[now.size()]);
    }

    public void addPositionProvider(IPositionProvider adapter) {
        HashSet<IPositionProvider> now = new HashSet<IPositionProvider>();
        now.addAll(Arrays.asList(this.fPositionAdapters));
        now.add(adapter);
        this.fPositionAdapters = now.toArray(new IPositionProvider[now.size()]);
    }

    public boolean providePosition(Object o, IPositionConsumer consumer) {
        int i = 0;
        while (i < this.fPositionAdapters.length) {
            IPositionProvider provider = this.fPositionAdapters[i];
            if (provider.providePosition(o, consumer)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

