/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.photran.core.FortranCorePlugin;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.preferences.FortranRGBPreference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FortranKeywordRuleBasedScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"ACCESS", "ACTION", "ADVANCE", "ALLOCATABLE", "ALLOCATE", "ASSIGN", "ASSIGNMENT", "ASSOCIATE", "ASYNCHRONOUS", "BACKSPACE", "BIND", "BLANK", "BLOCK", "CALL", "CASE", "CLOSE", "CLASS", "COMMON", "CONTAINS", "CONTINUE", "CYCLE", "DATA", "DEALLOCATE", "DEFAULT", "DELIM", "DIMENSION", "DIRECT", "DO", "DOUBLE", "DOUBLEPRECISION", "ELSE", "ELSEWHERE", "END", "ENDDO", "ENDFILE", "ENDIF", "ENTRY", "EOR", "EQUIVALENCE", "ERR", "EXIST", "EXIT", "EXTENDS", "EXTENSIBLE", "EXTERNAL", "FILE", "FMT", "FLUSH", "FORALL", "FORM", "FORMAT", "FORMATTED", "FUNCTION", "GO", "IF", "IMPLICIT", "IN", "INOUT", "INCLUDE", "INQUIRE", "INTENT", "INTERFACE", "INTRINSIC", "IOLENGTH", "IOSTAT", "INSTRINSIC", "KIND", "LEN", "MODULE", "NAME", "NAMED", "NAMELIST", "NEXTREC", "NML", "NONE", "NON_OVERRIDABLE", "NOPASS", "NULLIFY", "NUMBER", "ONLY", "OPEN", "OPENED", "OPERATOR", "OPTIONAL", "OUT", "PAD", "PARAMETER", "PASS", "PAUSE", "POINTER", "POSITION", "PRECISION", "PRINT", "PRIVATE", "PROCEDURE", "PROGRAM", "PROTECTED", "PUBLIC", "PURE", "READ", "READWRITE", "REC", "RECL", "RECURSIVE", "RESULT", "RETURN", "REWIND", "SAVE", "SELECT", "SEQUENCE", "SEQUENTIAL", "SIZE", "STAT", "STATUS", "STOP", "SUBROUTINE", "TARGET", "THEN", "TO", "TYPE", "UNFORMATTED", "UNIT", "USE", "VOLATILE", "WHERE", "WHILE", "WRITE"};
    private static String[] fgTextualOperators = new String[]{".EQ.", ".EQV.", ".FALSE.", ".GE.", ".GT.", ".LE.", ".NE.", ".NEQV.", ".NOT.", ".OR.", ".TRUE."};
    private static String[] fgIntrinsics = new String[]{"ABS", "ACHAR", "ACOS", "ADJUSTL", "ADJUSTR", "AIMAG", "AINT", "ALL", "ALLOCATED", "AND", "ANINT", "ANY", "ASIN", "ASSOCIATED", "ATAN", "ATAN2", "BIT_SIZE", "BTEST", "CEILING", "CHAR", "CMPLX", "CONJG", "COS", "COSH", "COUNT", "CSHIFT", "DATE_AND_TIME", "DBLE", "DIGITS", "DIM", "DOT_PRODUCT", "DPROD", "EOSHIFT", "EPSILON", "EQV", "EXP", "EXPONENT", "FALSE", "FLOOR", "FRACTION", "HUGE", "IACHAR", "IAND", "IBCLR", "IBITS", "IBSET", "ICHAR", "IEOR", "INDEX", "INT", "IOR", "ISHFT", "ISHFTC", "KIND", "LBOUND", "LEN", "LEN_TRIM", "LGE", "LGT", "LLE", "LLT", "LOG", "LOG10", "LOGICAL", "MATMUL", "MAX", "MAXEXPONENT", "MAXLOC", "MAXVAL", "MERGE", "MIN", "MINEXPONENT", "MINLOC", "MINVAL", "MOD", "MODULO", "MVBITS", "NEAREST", "NEQV", "NINT", "NOT", "OR", "PACK", "PRECISION", "PRESENT", "PRODUCT", "RADIX", "RANDOM_NUMBER", "RANDOM_SEED", "RANGE", "REAL", "REPEAT", "RESHAPE", "RRSPACING", "SCALE", "SCAN", "SELECTED_INT_KIND", "SELECTED_REAL_KIND", "SET_EXPONENT", "SHAPE", "SIGN", "SIN", "SINH", "SIZE", "SPACING", "SPREAD", "SQRT", "SUM", "SYSTEM_CLOCK", "TAN", "TANH", "TINY", "TRANSFER", "TRANSPOSE", "TRIM", "TRUE", "UBOUND", "UNPACK", "VERIFY"};
    private static String[] fgTypes = new String[]{"REAL", "INTEGER", "CHARACTER", "LOGICAL", "COMPLEX"};
    private static String[] fgPreprocessor = new String[]{"INCLUDE", "#include", "#error", "#warning", "#pragma", "#ifdef", "#ifndef", "#if", "#else", "#elif", "#endif", "#line"};
    private Token colorStrings = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_STRINGS);
    private Token colorComments = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_COMMENTS);
    private Token colorIdentifiers = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_IDENTIFIERS);
    private Token colorIntrinsics = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_INTRINSICS);
    private Token colorKeywords = FortranKeywordRuleBasedScanner.createTokenFromRGBPreference(FortranPreferences.COLOR_KEYWORDS);

    private static Token createTokenFromRGBPreference(FortranRGBPreference p) {
        int style = p == FortranPreferences.COLOR_KEYWORDS ? 1 : (p == FortranPreferences.COLOR_INTRINSICS ? 2 : 0);
        return new Token((Object)new TextAttribute(new Color(null, p.getValue()), null, style));
    }

    public FortranKeywordRuleBasedScanner(boolean isFixedForm, ISourceViewer sourceViewer) {
        WordRule rule;
        FortranCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new PreferenceChangeListener(sourceViewer));
        IRule[] rules = new IRule[isFixedForm ? 7 : 4];
        int i = 0;
        rules[i++] = new MultiLineRule("\"", "\"", (IToken)this.colorStrings);
        rules[i++] = new MultiLineRule("'", "'", (IToken)this.colorStrings);
        rules[i++] = new EndOfLineRule("!", (IToken)this.colorComments);
        if (isFixedForm) {
            EndOfLineRule c1 = new EndOfLineRule("c", (IToken)this.colorComments);
            c1.setColumnConstraint(0);
            rules[i++] = c1;
            EndOfLineRule c2 = new EndOfLineRule("C", (IToken)this.colorComments);
            c2.setColumnConstraint(0);
            rules[i++] = c2;
            FixedFormColumn72CommentRule c3 = new FixedFormColumn72CommentRule();
            rules[i++] = c3;
            rule = new FixedFormIdentifierWordRule(new FortranWordDetector(), (IToken)this.colorIdentifiers);
        } else {
            rule = new WordRule((IWordDetector)new FortranWordDetector(), (IToken)this.colorIdentifiers);
        }
        this.createSpecialWordRules(rule);
        rules[i++] = rule;
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)))));
    }

    private void createSpecialWordRules(WordRule rule) {
        int i = 0;
        while (i < fgTextualOperators.length) {
            rule.addWord(fgTextualOperators[i].toLowerCase(), (IToken)this.colorKeywords);
            rule.addWord(fgTextualOperators[i], (IToken)this.colorKeywords);
            ++i;
        }
        i = 0;
        while (i < fgPreprocessor.length) {
            rule.addWord(fgPreprocessor[i], (IToken)this.colorKeywords);
            ++i;
        }
        i = 0;
        while (i < fgIntrinsics.length) {
            rule.addWord(fgIntrinsics[i].toLowerCase(), (IToken)this.colorIntrinsics);
            rule.addWord(fgIntrinsics[i], (IToken)this.colorIntrinsics);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            rule.addWord(fgTypes[i].toLowerCase(), (IToken)this.colorKeywords);
            rule.addWord(fgTypes[i], (IToken)this.colorKeywords);
            ++i;
        }
        i = 0;
        while (i < fgKeywords.length) {
            rule.addWord(fgKeywords[i].toLowerCase(), (IToken)this.colorKeywords);
            rule.addWord(fgKeywords[i], (IToken)this.colorKeywords);
            ++i;
        }
    }

    private final class FixedFormColumn72CommentRule
    implements IRule {
        private FixedFormColumn72CommentRule() {
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken result = Token.UNDEFINED;
            scanner.read();
            if (scanner.getColumn() > 72) {
                result = FortranKeywordRuleBasedScanner.this.colorComments;
                do {
                    scanner.read();
                } while (scanner.getColumn() > 72);
            }
            scanner.unread();
            return result;
        }
    }

    private static final class FixedFormIdentifierWordRule
    extends WordRule {
        private StringBuffer fBuffer = new StringBuffer();

        private FixedFormIdentifierWordRule(IWordDetector detector, IToken token) {
            super(detector, token);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if (this.fDetector.isWordStart((char)c) && scanner.getColumn() >= 7) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c) && scanner.getColumn() <= 72);
                scanner.unread();
                IToken token = (IToken)this.fWords.get(this.fBuffer.toString());
                if (token != null) {
                    return token;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unreadBuffer(scanner);
                }
                return this.fDefaultToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static final class FortranWordDetector
    implements IWordDetector {
        private FortranWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c) || c == '.';
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c) || c == '.';
        }
    }

    private final class PreferenceChangeListener
    implements Preferences.IPropertyChangeListener {
        private ISourceViewer sourceViewer;

        PreferenceChangeListener(ISourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String newVal;
            String property = event.getProperty();
            String string = newVal = event.getNewValue() instanceof String ? (String)event.getNewValue() : null;
            if (property.equals(FortranPreferences.COLOR_COMMENTS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorComments, newVal);
            } else if (property.equals(FortranPreferences.COLOR_STRINGS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorStrings, newVal);
            } else if (property.equals(FortranPreferences.COLOR_IDENTIFIERS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorIdentifiers, newVal);
            } else if (property.equals(FortranPreferences.COLOR_INTRINSICS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorIntrinsics, newVal);
            } else if (property.equals(FortranPreferences.COLOR_KEYWORDS.getName())) {
                this.updateToken(FortranKeywordRuleBasedScanner.this.colorKeywords, newVal);
            }
        }

        private void updateToken(Token token, String newColor) {
            Object data = token.getData();
            if (data instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(new Color(null, StringConverter.asRGB((String)newColor)), oldAttr.getBackground(), oldAttr.getStyle()));
            }
            this.sourceViewer.invalidateTextPresentation();
        }
    }
}

