/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.ui.MacrosBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewBuildMacroDialog
extends StatusDialog {
    private static final String PREFIX = "NewBuildMacroDialog";
    private static final String LABEL = "NewBuildMacroDialog.label";
    private static final String NAME = "NewBuildMacroDialog.label.name";
    private static final String VALUE = "NewBuildMacroDialog.label.value";
    private static final String TYPE = "NewBuildMacroDialog.label.type";
    private static final String TYPE_TEXT = "NewBuildMacroDialog.label.type.text";
    private static final String TYPE_TEXT_LIST = "NewBuildMacroDialog.label.type.text.list";
    private static final String TYPE_PATH_FILE = "NewBuildMacroDialog.label.type.path.file";
    private static final String TYPE_PATH_FILE_LIST = "NewBuildMacroDialog.label.type.path.file.list";
    private static final String TYPE_PATH_DIR = "NewBuildMacroDialog.label.type.path.dir";
    private static final String TYPE_PATH_DIR_LIST = "NewBuildMacroDialog.label.type.path.dir.list";
    private static final String TYPE_PATH_ANY = "NewBuildMacroDialog.label.type.path.any";
    private static final String TYPE_PATH_ANY_LIST = "NewBuildMacroDialog.label.type.path.any.list";
    private static final String BROWSE = "NewBuildMacroDialog.label.browse";
    private static final String LIST_TITLE = "NewBuildMacroDialog.label.list.title";
    private static final String TITLE_NEW = "NewBuildMacroDialog.label.title.new";
    private static final String TITLE_EDIT = "NewBuildMacroDialog.label.title.edit";
    private static final String STATUS = "NewBuildMacroDialog.label.status";
    private static final String STATUS_CANNOT_CTREATE = "NewBuildMacroDialog.label.status.cannot.create";
    private static final String EMPTY_STRING = new String();
    private String fTitle;
    private IBuildMacro fEditedMacro;
    private MacrosBlock fMacrosBlock;
    private IBuildMacro fResultingMacro;
    private String fReplaceValue = null;
    private String fAppPrepValue = null;
    private boolean fAppPrepPrepend = true;
    private boolean fTotalSizeCalculated;
    private String fTypedName;
    private int fTypedType = -1;
    private Composite fContainer;
    private Combo fMacroNameEdit;
    private Label fMacroValueLabel;
    private Text fMacroValueEdit;
    private Button fBrowseButton;
    private Combo fTypeSelector;
    private Composite fListEditorContainier;
    private FileListControl fListEditor;

    public NewBuildMacroDialog(Shell parentShell, MacrosBlock macrosBlock, IBuildMacro editedMacro) {
        super(parentShell);
        this.fTitle = editedMacro != null ? ManagedBuilderUIMessages.getResourceString(TITLE_EDIT) : ManagedBuilderUIMessages.getResourceString(TITLE_NEW);
        this.fEditedMacro = editedMacro;
        this.fMacrosBlock = macrosBlock;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fContainer = comp;
        Label nameLabel = new Label(comp, 16384);
        nameLabel.setFont(comp.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        nameLabel.setLayoutData((Object)new GridData());
        this.fMacroNameEdit = new Combo(comp, 4);
        this.fMacroNameEdit.setItems(this.getMacroNames());
        this.fMacroNameEdit.setFont(comp.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.fMacroNameEdit.setLayoutData((Object)gd);
        this.fMacroNameEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuildMacroDialog.this.handleMacroNameModified();
            }
        });
        this.fMacroNameEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBuildMacroDialog.this.handleMacroNameSelection();
            }
        });
        Label typeLabel = new Label(comp, 16384);
        typeLabel.setFont(comp.getFont());
        typeLabel.setText(ManagedBuilderUIMessages.getResourceString(TYPE));
        gd = new GridData();
        gd.horizontalSpan = 1;
        typeLabel.setLayoutData((Object)gd);
        this.fTypeSelector = new Combo(comp, 12);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTypeSelector.setLayoutData((Object)gd);
        this.fTypeSelector.setItems(new String[]{ManagedBuilderUIMessages.getResourceString(TYPE_TEXT), ManagedBuilderUIMessages.getResourceString(TYPE_TEXT_LIST), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_FILE), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_FILE_LIST), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_DIR), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_DIR_LIST), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_ANY), ManagedBuilderUIMessages.getResourceString(TYPE_PATH_ANY_LIST)});
        this.setSelectedType(1);
        this.fTypeSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NewBuildMacroDialog.this.handleTypeModified();
            }
        });
        this.fMacroValueLabel = new Label(comp, 16384);
        this.fMacroValueLabel.setFont(comp.getFont());
        this.fMacroValueLabel.setText(ManagedBuilderUIMessages.getResourceString(VALUE));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.fMacroValueLabel.setLayoutData((Object)gd);
        this.fMacroValueEdit = new Text(comp, 2052);
        this.fMacroValueEdit.setFont(comp.getFont());
        gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 1;
        this.fMacroValueEdit.setLayoutData((Object)gd);
        this.fMacroValueEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuildMacroDialog.this.handleMacroValueModified();
            }
        });
        this.fBrowseButton = new Button(comp, 8);
        this.fBrowseButton.setFont(comp.getFont());
        this.fBrowseButton.setText(ManagedBuilderUIMessages.getResourceString(BROWSE));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBuildMacroDialog.this.handleBrowseButtonPressed();
            }
        });
        gd = new GridData();
        gd.widthHint = 61;
        gd.horizontalSpan = 1;
        this.fBrowseButton.setLayoutData((Object)gd);
        this.fListEditorContainier = new Composite(comp, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.fListEditorContainier.setLayoutData((Object)gd);
        this.fListEditorContainier.setLayout((Layout)new GridLayout());
        this.fListEditor = new FileListControl(this.fListEditorContainier, ManagedBuilderUIMessages.getResourceString(LIST_TITLE), 0);
        this.fListEditor.setWorkspaceSupport(true);
        this.fListEditor.setContext(this.fMacrosBlock.getContextInfo());
        if (this.fEditedMacro != null) {
            this.loadMacroSettings(this.fEditedMacro, true);
            this.fMacroNameEdit.setEnabled(false);
        }
        return comp;
    }

    private String[] getMacroNames() {
        IBuildMacro[] macros = this.fMacrosBlock.getSystemMacros(true);
        String[] names = null;
        if (macros == null || macros.length == 0) {
            names = new String[]{};
        } else {
            names = new String[macros.length];
            int i = 0;
            while (i < macros.length) {
                names[i] = macros[i].getName();
                ++i;
            }
            final Collator collator = Collator.getInstance();
            Arrays.sort(names, new Comparator(){

                public int compare(Object a, Object b) {
                    String strA = ((String)a).toUpperCase();
                    String strB = ((String)b).toUpperCase();
                    return collator.compare(strA, strB);
                }
            });
        }
        return names;
    }

    private void handleBrowseButtonPressed() {
        switch (this.getBrowseType(this.getSelectedType())) {
            case 1: {
                FileDialog fileDlg = new FileDialog(this.fBrowseButton.getShell());
                String file = fileDlg.open();
                if (file == null) break;
                this.fMacroValueEdit.setText(file);
                break;
            }
            case 2: {
                DirectoryDialog dirDlg = new DirectoryDialog(this.fBrowseButton.getShell());
                String dir = dirDlg.open();
                if (dir == null) break;
                this.fMacroValueEdit.setText(dir);
            }
        }
    }

    private int getBrowseType(int type) {
        int browseType = 0;
        switch (type) {
            case 3: 
            case 4: {
                browseType = 1;
                break;
            }
            case 5: 
            case 6: {
                browseType = 2;
                break;
            }
        }
        return browseType;
    }

    private void handleMacroNameSelection() {
        int index = this.fMacroNameEdit.getSelectionIndex();
        if (index == -1) {
            this.loadMacroSettings(null);
        } else {
            this.loadMacroSettings(this.fMacroNameEdit.getItem(index));
        }
    }

    private void loadMacroSettings(String name) {
        IBuildMacro macro = this.fMacrosBlock.getSystemMacro(name, true);
        if (macro != null) {
            this.loadMacroSettings(macro, false);
        } else {
            this.loadMacroSettings(name, 1, EMPTY_STRING);
        }
    }

    private void loadMacroSettings(String name, int type, String[] value) {
        this.setSelectedType(type);
        this.setSelectedMacroName(this.notNull(name));
        this.fListEditor.setList(value);
        this.updateWidgetState();
    }

    private void loadMacroSettings(String name, int type, String value) {
        this.setSelectedType(type);
        this.setSelectedMacroName(this.notNull(name));
        this.fMacroValueEdit.setText(this.notNull(value));
        this.updateWidgetState();
    }

    private void loadMacroSettings(IBuildMacro macro, boolean isUser) {
        try {
            if (MacroResolver.isStringListMacro((int)macro.getMacroValueType())) {
                this.loadMacroSettings(macro.getName(), macro.getMacroValueType(), macro.getStringListValue());
            } else {
                this.loadMacroSettings(macro.getName(), macro.getMacroValueType(), macro.getStringValue());
            }
        }
        catch (BuildMacroException buildMacroException) {}
    }

    private String notNull(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    private String getSelectedVarName() {
        return this.fMacroNameEdit.getText().trim();
    }

    private void setSelectedMacroName(String name) {
        if (!this.macroNamesEqual(this.fMacroNameEdit.getText(), name)) {
            this.fTypedName = name;
            this.fMacroNameEdit.setText(this.notNull(name).trim());
        }
    }

    private boolean macroNamesEqual(String name1, String name2) {
        name1 = name1.trim();
        name2 = name2.trim();
        return name1.equalsIgnoreCase(name2);
    }

    private int getSelectedType() {
        switch (this.fTypeSelector.getSelectionIndex()) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
        }
        return 1;
    }

    private void setSelectedType(int type) {
        switch (type) {
            case 2: {
                this.fTypeSelector.select(1);
                break;
            }
            case 3: {
                this.fTypeSelector.select(2);
                break;
            }
            case 4: {
                this.fTypeSelector.select(3);
                break;
            }
            case 5: {
                this.fTypeSelector.select(4);
                break;
            }
            case 6: {
                this.fTypeSelector.select(5);
                break;
            }
            case 7: {
                this.fTypeSelector.select(6);
                break;
            }
            case 8: {
                this.fTypeSelector.select(7);
                break;
            }
            default: {
                this.fTypeSelector.select(0);
            }
        }
    }

    protected void okPressed() {
        String name = this.getSelectedVarName();
        if (name != null || !EMPTY_STRING.equals(name)) {
            int type = this.getSelectedType();
            this.fResultingMacro = MacroResolver.isStringListMacro((int)type) ? new BuildMacro(name, type, this.getSelectedStringListValue()) : new BuildMacro(name, type, this.getSelectedStringValue());
        }
        super.okPressed();
    }

    public int open() {
        this.fResultingMacro = null;
        return super.open();
    }

    private String getSelectedStringValue() {
        return this.fMacroValueEdit.getText();
    }

    private String[] getSelectedStringListValue() {
        return this.fListEditor.getItems();
    }

    public IBuildMacro getDefinedMacro() {
        return this.fResultingMacro;
    }

    private void handleMacroNameModified() {
        String name = this.getSelectedVarName();
        if (this.fTypedName == null || !this.fTypedName.equals(name)) {
            this.loadMacroSettings(name);
        }
    }

    private void handleMacroValueModified() {
    }

    private void handleTypeModified() {
        int type = this.getSelectedType();
        if (this.fTypedType != -1 && this.fTypedType == type) {
            return;
        }
        this.fTypedType = type;
        this.adjustLayout(type);
    }

    private void adjustLayout(int type) {
        GridData listGd = (GridData)this.fListEditorContainier.getLayoutData();
        GridData labelGd = (GridData)this.fMacroValueLabel.getLayoutData();
        GridData editGd = (GridData)this.fMacroValueEdit.getLayoutData();
        GridData browseGd = (GridData)this.fBrowseButton.getLayoutData();
        if (MacroResolver.isStringListMacro((int)type)) {
            listGd.exclude = false;
            labelGd.exclude = true;
            editGd.exclude = true;
            browseGd.exclude = true;
            this.fListEditorContainier.setVisible(true);
            this.fListEditor.setType(this.getBrowseType(type));
            this.fMacroValueLabel.setVisible(false);
            this.fMacroValueEdit.setVisible(false);
            this.fBrowseButton.setVisible(false);
        } else {
            int editSpan;
            listGd.exclude = true;
            labelGd.exclude = false;
            editGd.exclude = false;
            this.fListEditorContainier.setVisible(false);
            this.fMacroValueLabel.setVisible(true);
            this.fMacroValueEdit.setVisible(true);
            if (this.getBrowseType(type) != 0) {
                browseGd.exclude = false;
                editSpan = 1;
                this.fBrowseButton.setVisible(true);
            } else {
                browseGd.exclude = true;
                editSpan = 2;
                this.fBrowseButton.setVisible(false);
            }
            editGd.horizontalSpan = editSpan;
        }
        this.fContainer.layout(true, true);
    }

    private void updateWidgetState() {
        if (!this.fTotalSizeCalculated) {
            return;
        }
        this.handleTypeModified();
        this.validateState();
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        this.fTotalSizeCalculated = true;
        this.updateWidgetState();
        return size;
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        String name = this.getSelectedVarName();
        if (EMPTY_STRING.equals(name)) {
            status.setError("");
        } else if (!this.fMacrosBlock.canCreate(name)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(STATUS_CANNOT_CTREATE, name));
        }
        this.updateStatus((IStatus)status);
    }
}

