/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;

public class MonitoringSystemChoices {
    public static final int SIMULATED = 100;
    public static final int ORTE = 101;
    public static final int LAMPI = 102;
    public static final int LAMMPI = 103;
    public static final int MPICH1 = 104;
    public static final int MPICH2 = 105;
    private static String[] NonDevelMSChoices = new String[]{"Open Runtime Environment (ORTE)", "MPICH 2.x (MPD)"};
    private static int[] NonDevelMSIDs = new int[]{101, 105};
    private static String[] DevelMSChoices = new String[]{"Simulated", "Open Runtime Environment (ORTE)", "MPICH 2.x (MPD)"};
    private static int[] DevelMSIDs = new int[]{100, 101, 105};

    public static boolean queryDevelMode() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean("DEVELOPER_MODE");
    }

    public static String[] queryMSChoices() {
        if (MonitoringSystemChoices.queryDevelMode()) {
            return DevelMSChoices;
        }
        return NonDevelMSChoices;
    }

    public static int[] queryMSIDs() {
        if (MonitoringSystemChoices.queryDevelMode()) {
            return DevelMSIDs;
        }
        return NonDevelMSIDs;
    }

    public static String[] getMSStrings() {
        return MonitoringSystemChoices.queryMSChoices();
    }

    public static int getMSArrayIndexByName(String MSname) {
        int i = 0;
        while (i < MonitoringSystemChoices.queryMSChoices().length) {
            if (MSname.equals(MonitoringSystemChoices.queryMSChoices()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getMSArrayIndexByID(int ID) {
        int i = 0;
        while (i < MonitoringSystemChoices.queryMSIDs().length) {
            if (ID == MonitoringSystemChoices.queryMSIDs()[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getMSIDByName(String MSname) {
        int idx = MonitoringSystemChoices.getMSArrayIndexByName(MSname);
        if (idx < 0) {
            return idx;
        }
        return MonitoringSystemChoices.queryMSIDs()[idx];
    }

    public static int getMSIDByIndex(int idx) {
        if (idx < 0 || idx >= MonitoringSystemChoices.queryMSIDs().length) {
            return -1;
        }
        return MonitoringSystemChoices.queryMSIDs()[idx];
    }

    public static String getMSNameByID(int ID) {
        int i = 0;
        while (i < MonitoringSystemChoices.queryMSIDs().length) {
            if (ID == MonitoringSystemChoices.queryMSIDs()[i]) {
                return MonitoringSystemChoices.queryMSChoices()[i];
            }
            ++i;
        }
        return "<UNDEFINED MS>";
    }

    public static String getMSNameByIndex(int idx) {
        if (idx < 0 || idx >= MonitoringSystemChoices.queryMSChoices().length) {
            return "<UNDEFINED MS>";
        }
        return MonitoringSystemChoices.queryMSChoices()[idx];
    }
}

