/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;

public final class ArrayAttribute
extends AbstractAttribute {
    private final IAttribute[] attributes;
    private String delimeter;

    protected static int compareLexigraphically(SortedSet lhs, SortedSet rhs) {
        int size2;
        Iterator first1 = lhs.iterator();
        Iterator first2 = rhs.iterator();
        while (first1.hasNext() && first2.hasNext()) {
            Comparable o2;
            Comparable o1 = (Comparable)first1.next();
            int o1Co2 = o1.compareTo(o2 = (Comparable)first2.next());
            if (o1Co2 == 0) continue;
            return o1Co2;
        }
        int size1 = lhs.size();
        if (size1 < (size2 = rhs.size())) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        return 0;
    }

    public ArrayAttribute(IAttributeDescription description, IAttribute[] attributes) {
        this(description, attributes, ", ");
    }

    public ArrayAttribute(IAttributeDescription description, IAttribute[] attributes, String delimiter) {
        super(description);
        this.delimeter = delimiter;
        this.attributes = (IAttribute[])attributes.clone();
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        throw new IAttribute.IllegalValue("Cannot create an ArrayAttribute from a String representation.");
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayAttribute) {
            ArrayAttribute attr = (ArrayAttribute)obj;
            return Arrays.deepEquals(this.attributes, attr.attributes);
        }
        return false;
    }

    public IAttribute[] getAttributes() {
        return (IAttribute[])this.attributes.clone();
    }

    public String getDelimiter() {
        return this.delimeter;
    }

    public String getStringRep() {
        StringBuffer buf = new StringBuffer("(");
        int i = 0;
        while (i < this.attributes.length - 1) {
            buf.append(String.valueOf(this.attributes[i].toString()) + this.delimeter);
            ++i;
        }
        if (this.attributes.length > 0) {
            buf.append(this.attributes[this.attributes.length - 1]);
        }
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.attributes);
    }

    public void setDelimiter(String delimiter) {
        this.delimeter = delimiter;
    }

    protected int doCompareTo(AbstractAttribute obj) {
        ArrayAttribute env = (ArrayAttribute)obj;
        TreeSet thisAttrs = new TreeSet(Arrays.asList(this.attributes));
        TreeSet otherAttrs = new TreeSet(Arrays.asList(env.attributes));
        return ArrayAttribute.compareLexigraphically(thisAttrs, otherAttrs);
    }
}

