/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDescription;
import org.eclipse.ptp.core.attributes.IMutableAttribute;

public final class MutableIntegerAttribute
extends AbstractAttribute
implements IMutableAttribute {
    private Integer value;

    public MutableIntegerAttribute(IAttributeDescription description, int value) {
        super(description);
        this.value = value;
    }

    public MutableIntegerAttribute(IAttributeDescription description, String string) throws IAttribute.IllegalValue {
        super(description);
        try {
            this.value = Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    public IAttribute create(String string) throws IAttribute.IllegalValue {
        return new MutableIntegerAttribute(this.getDescription(), string);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableIntegerAttribute) {
            MutableIntegerAttribute attr = (MutableIntegerAttribute)obj;
            return this.value.equals(attr.value);
        }
        return false;
    }

    public String getStringRep() {
        return this.value.toString();
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isValid(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setValue(String string) throws IAttribute.IllegalValue {
        try {
            this.value = Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IAttribute.IllegalValue(e);
        }
    }

    protected int doCompareTo(AbstractAttribute arg0) {
        MutableIntegerAttribute attr = (MutableIntegerAttribute)arg0;
        return this.value.compareTo(attr.value);
    }
}

