/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.internal.core.elementcontrols.IPElementControl;

public class PElementInfo {
    private Map fChildren = null;
    protected IPElementControl element;

    public PElementInfo(IPElementControl element) {
        this.element = element;
        this.fChildren = new HashMap(0);
    }

    public IPElementControl getElement() {
        return this.element;
    }

    public void addChild(IPElementControl member) {
        this.fChildren.put(member.getIDString(), member);
    }

    public void removeChild(IPElementControl member) {
        this.fChildren.remove(member.getIDString());
    }

    public IPElementControl findChild(String key) {
        if (this.fChildren.containsKey(key)) {
            return (IPElementControl)this.fChildren.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPElementControl[] getChildren() {
        Map map = this.fChildren;
        synchronized (map) {
            return this.fChildren.values().toArray(new IPElementControl[this.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCollection() {
        Map map = this.fChildren;
        synchronized (map) {
            return this.fChildren.values();
        }
    }

    public boolean includesChild(IPElementControl child) {
        return this.fChildren.containsKey(child.getIDString());
    }

    public void removeChildren() {
        this.fChildren.clear();
    }

    public void setChildren(Map children) {
        this.fChildren.putAll(children);
    }

    public boolean hasChildren() {
        return this.size() > 0;
    }

    public int size() {
        return this.fChildren.size();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

