/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.aif;

import org.eclipse.ptp.debug.core.aif.AIFFactory;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.internal.core.aif.TypeDerived;

public class AIFTypeArray
extends TypeDerived
implements IAIFTypeArray {
    private int size = 1;
    private int low = 0;
    private int high = 0;
    private int dimension = 0;

    public AIFTypeArray(String format, IAIFType basetype) {
        super(basetype);
        this.parse(format);
    }

    private void parse(String fmt) {
        int low_pos = AIFFactory.getDigitPos(fmt, 1);
        this.low = Integer.parseInt(fmt.substring(1, low_pos));
        int up_pos = AIFFactory.getDigitPos(fmt, low_pos + 2);
        this.high = Integer.parseInt(fmt.substring(low_pos + 2, up_pos));
        this.size = this.size * (this.high - this.low + 1) * this.basetype.sizeof();
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public int getRange() {
        return this.high - this.low + 1;
    }

    public IAIFType getFoundationType() {
        if (this.basetype instanceof IAIFTypeArray) {
            return ((IAIFTypeArray)this.basetype).getFoundationType();
        }
        return this.basetype;
    }

    public int getDimension() {
        if (this.dimension == 0) {
            this.dimension = 1;
            if (this.basetype instanceof IAIFTypeArray) {
                this.dimension += ((IAIFTypeArray)this.basetype).getDimension();
            }
        }
        return this.dimension;
    }

    public boolean isDimensionArray() {
        return this.basetype instanceof IAIFTypeArray;
    }

    public IAIFTypeArray getAIFTypeArray(int dim_pos) {
        if (dim_pos == 0) {
            return this;
        }
        if (dim_pos < 0 || dim_pos > this.getDimension() - 1) {
            return null;
        }
        return ((IAIFTypeArray)this.basetype).getAIFTypeArray(dim_pos - 1);
    }

    public int sizeof() {
        return this.size;
    }

    public String toString(int range) {
        return this.getAIFTypeArray(range).toString();
    }

    public String toString() {
        return "[r" + this.low + ".." + this.high + "U]" + this.basetype.toString();
    }

    public static void main(String[] args) {
        String fmt = "[r0..2is4][r0..5is4][r0..5is4][r0..5is4][r0..5is4]is4";
        IAIFType type = AIFFactory.getAIFType(fmt);
        if (type instanceof IAIFTypeArray) {
            System.err.println("dim: " + ((IAIFTypeArray)type).getDimension());
            System.err.println("base: " + ((IAIFTypeArray)type).getBaseType());
            System.err.println("foundation: " + ((IAIFTypeArray)type).getFoundationType());
        }
        System.err.println("size: " + type.sizeof());
        System.err.println("1st: " + ((IAIFTypeArray)type).getAIFTypeArray(0));
    }
}

