/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.aif.IAIFType;
import org.eclipse.ptp.debug.core.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PType;
import org.eclipse.ptp.debug.internal.core.model.PValueFactory;
import org.eclipse.ptp.debug.internal.core.model.PVariable;

public class PLocalVariable
extends PVariable {
    public PLocalVariable(PDebugElement parent, IPCDIVariableDescriptor cdiVariableObject, String errorMessage) {
        super(parent, cdiVariableObject, errorMessage);
    }

    public PLocalVariable(PDebugElement parent, IPCDIVariableDescriptor cdiVariableObject) {
        super(parent, cdiVariableObject);
    }

    protected void createOriginal(IPCDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    private class InternalVariable
    implements PVariable.IInternalVariable {
        private PVariable fVariable;
        private IPCDIVariableDescriptor fCDIVariableObject;
        private IPCDIVariable fCDIVariable;
        private PType fType;
        private String fQualifiedName;
        private IPValue fValue = PValueFactory.NULL_VALUE;
        private boolean fChanged = false;

        InternalVariable(PVariable var, IPCDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setCDIVariableObject(varObject);
            this.setCDIVariable(varObject instanceof IPCDIVariable ? (IPCDIVariable)varObject : null);
        }

        public PVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (PCDIException e) {
                PLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public PVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (PCDIException e) {
                PLocalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        private synchronized IPCDIVariable getCDIVariable() throws DebugException {
            if (this.fCDIVariable == null) {
                try {
                    this.fCDIVariable = ((PStackFrame)PLocalVariable.this.getStackFrame()).getCDIStackFrame().createLocalVariable((IPCDILocalVariableDescriptor)this.getCDIVariableObject());
                }
                catch (PCDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fCDIVariable;
        }

        private void setCDIVariable(IPCDIVariable variable) {
            this.fCDIVariable = variable;
        }

        private IPCDIVariableDescriptor getCDIVariableObject() {
            if (this.fCDIVariable != null) {
                return this.fCDIVariable;
            }
            return this.fCDIVariableObject;
        }

        private void setCDIVariableObject(IPCDIVariableDescriptor variableObject) {
            this.fCDIVariableObject = variableObject;
        }

        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
                }
                catch (PCDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PType getType() throws DebugException {
            IPCDIVariableDescriptor varObject;
            if (this.fType == null && (varObject = this.getCDIVariableObject()) != null) {
                InternalVariable internalVariable = this;
                synchronized (internalVariable) {
                    if (this.fType == null) {
                        try {
                            this.fType = new PType(varObject.getType());
                        }
                        catch (CDIException e) {
                            PLocalVariable.requestFailed(e.getMessage(), null);
                        }
                    }
                }
            }
            return this.fType;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fCDIVariable != null) {
                    this.fCDIVariable.dispose();
                }
            }
            catch (PCDIException e) {
                PLocalVariable.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setCDIVariable(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
        }

        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean isSameVariable(IPCDIVariable cdiVar) {
            return this.fCDIVariable != null ? this.fCDIVariable.equals(cdiVar) : false;
        }

        public int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (PCDIException pCDIException) {}
            }
            return 0;
        }

        public boolean isArgument() {
            return this.getCDIVariableObject() instanceof IPCDIArgumentDescriptor;
        }

        public void setValue(String expression) throws DebugException {
            IPCDIVariable cdiVariable = null;
            try {
                cdiVariable = this.getCDIVariable();
                if (cdiVariable != null) {
                    cdiVariable.setValue(expression);
                } else {
                    PLocalVariable.requestFailed(CoreModelMessages.getString("PModificationVariable.0"), null);
                }
            }
            catch (PCDIException e) {
                PLocalVariable.targetRequestFailed(e.getMessage(), null);
            }
        }

        public synchronized IPValue getValue() throws DebugException {
            IPCDIVariable var;
            if (this.fValue.equals(PValueFactory.NULL_VALUE) && (var = this.getCDIVariable()) != null) {
                try {
                    IAIFType aifType = var.getType();
                    if (aifType != null && aifType instanceof IAIFTypeArray) {
                        int[] dims;
                        PType type = new PType(aifType);
                        if (type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                            this.fValue = PValueFactory.createIndexedValue(this.getVariable(), var, 0, dims[0]);
                        }
                    } else {
                        this.fValue = PValueFactory.createValue(this.getVariable(), var);
                    }
                }
                catch (PCDIException e) {
                    PLocalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fValue;
        }

        public void invalidateValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).dispose();
                this.fValue = PValueFactory.NULL_VALUE;
                if (this.fCDIVariable != null) {
                    this.fCDIVariable.resetValue();
                }
            }
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).preserve();
            }
        }

        PVariable getVariable() {
            return this.fVariable;
        }

        private void setVariable(PVariable variable) {
            this.fVariable = variable;
        }

        public void resetValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).reset();
            }
        }

        public boolean isEditable() throws DebugException {
            IPCDIVariable var = this.getCDIVariable();
            if (var != null) {
                try {
                    return var.isEditable();
                }
                catch (PCDIException pCDIException) {}
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getCDIVariableObject().equals(((InternalVariable)obj).getCDIVariableObject());
            }
            return false;
        }

        public boolean isSameDescriptor(IPCDIVariableDescriptor desc) {
            return this.getCDIVariableObject().equals(desc);
        }
    }
}

