/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public class PSignal
extends PDebugElement
implements IPSignal,
IPCDIEventListener {
    private IPCDISignal fCDISignal;

    public PSignal(PDebugTarget target, IPCDISignal cdiSignal) {
        super(target);
        this.fCDISignal = cdiSignal;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public String getDescription() throws DebugException {
        return this.getCDISignal().getDescription();
    }

    public String getName() throws DebugException {
        return this.getCDISignal().getName();
    }

    public boolean isPassEnabled() throws DebugException {
        return !this.getCDISignal().isIgnore();
    }

    public boolean isStopEnabled() throws DebugException {
        return this.getCDISignal().isStopSet();
    }

    public void setPassEnabled(boolean enable) throws DebugException {
        this.handle(enable, this.isStopEnabled());
    }

    public void setStopEnabled(boolean enable) throws DebugException {
        this.handle(this.isPassEnabled(), enable);
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
    }

    public void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public void signal() throws DebugException {
        try {
            this.getCDITarget().resume(this.getCDISignal());
        }
        catch (PCDIException e) {
            PSignal.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected IPCDISignal getCDISignal() {
        return this.fCDISignal;
    }

    private void handle(boolean pass, boolean stop) throws DebugException {
        try {
            this.getCDISignal().handle(!pass, stop);
        }
        catch (PCDIException e) {
            PSignal.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canModify() {
        return true;
    }
}

