/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIMemoryChangedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIRestartedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIMemoryBlock;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;
import org.eclipse.ptp.debug.core.model.IExecFileInfo;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;

public class PTPMemoryBlockExtension
extends PDebugElement
implements IMemoryBlockExtension,
IPCDIEventListener {
    private String fExpression;
    private BigInteger fBaseAddress;
    private IPCDIMemoryBlock fCDIBlock;
    private MemoryByte[] fBytes = null;
    private HashSet fChanges = new HashSet();
    private int fWordSize;

    public PTPMemoryBlockExtension(PDebugTarget target, String expression, BigInteger baseAddress) {
        this(target, expression, baseAddress, 1);
    }

    public PTPMemoryBlockExtension(PDebugTarget target, String expression, BigInteger baseAddress, int wordSize) {
        super(target);
        this.fExpression = expression;
        this.fBaseAddress = baseAddress;
        this.fWordSize = wordSize;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public BigInteger getBigBaseAddress() {
        return this.fBaseAddress;
    }

    public int getAddressSize() {
        return ((PDebugTarget)this.getDebugTarget()).getAddressFactory().createAddress(this.getBigBaseAddress()).getSize();
    }

    public int getAddressableSize() throws DebugException {
        IPCDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getWordSize() : this.fWordSize;
    }

    public boolean supportBaseAddressModification() {
        return true;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryByte[] getBytesFromAddress(BigInteger address, long length) throws DebugException {
        int offset;
        IPCDIMemoryBlock cdiBlock = this.getCDIBlock();
        if (cdiBlock == null || cdiBlock.getStartAddress().compareTo(address) > 0 || cdiBlock.getStartAddress().add(BigInteger.valueOf(cdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
            PTPMemoryBlockExtension pTPMemoryBlockExtension = this;
            synchronized (pTPMemoryBlockExtension) {
                byte[] bytes = null;
                try {
                    cdiBlock = this.getCDIBlock();
                    if (cdiBlock == null || cdiBlock.getStartAddress().compareTo(address) > 0 || cdiBlock.getStartAddress().add(BigInteger.valueOf(cdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
                        if (cdiBlock != null) {
                            this.disposeCDIBlock();
                            this.fBytes = null;
                        }
                        this.setCDIBlock(this.createCDIBlock(address, length, this.fWordSize));
                    }
                    bytes = this.getCDIBlock().getBytes();
                }
                catch (PCDIException e) {
                    PTPMemoryBlockExtension.targetRequestFailed(e.getMessage(), null);
                }
                this.fBytes = new MemoryByte[bytes.length];
                int i = 0;
                while (i < bytes.length) {
                    this.fBytes[i] = this.createMemoryByte(bytes[i], this.getCDIBlock().getFlags(i), this.hasChanged(this.getRealBlockAddress().add(BigInteger.valueOf(i))));
                    ++i;
                }
            }
        }
        MemoryByte[] result = new MemoryByte[]{};
        if (this.fBytes != null && (offset = address.subtract(this.getRealBlockAddress()).intValue()) >= 0) {
            int size;
            int n = size = (long)(this.fBytes.length - offset) >= length ? (int)length : this.fBytes.length - offset;
            if (size > 0) {
                result = new MemoryByte[size];
                System.arraycopy(this.fBytes, offset, result, 0, size);
            }
        }
        return result;
    }

    private boolean isBigEndian() {
        IExecFileInfo info = (IExecFileInfo)this.getDebugTarget().getAdapter(IExecFileInfo.class);
        if (info != null) {
            return !info.isLittleEndian();
        }
        return false;
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return (IMemoryBlockRetrieval)this.getDebugTarget().getAdapter(IMemoryBlockRetrieval.class);
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPCDIEvent event = events[i];
            IPCDIObject source = event.getSource(this.getCDITarget().getTargetID());
            if (source != null && source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof IPCDIResumedEvent || event instanceof IPCDIRestartedEvent) {
                    this.resetChanges();
                } else if (event instanceof IPCDIMemoryChangedEvent && source instanceof IPCDIMemoryBlock && source.equals(this.getCDIBlock())) {
                    this.handleChangedEvent((IPCDIMemoryChangedEvent)event);
                }
            }
            ++i;
        }
    }

    public long getStartAddress() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        return null;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
        this.setValue(BigInteger.valueOf(offset), bytes);
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        IPCDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            BigInteger base = this.getBigBaseAddress();
            BigInteger real = this.getRealBlockAddress();
            long realOffset = base.add(offset).subtract(real).longValue();
            try {
                block.setValue(realOffset, bytes);
            }
            catch (PCDIException e) {
                PTPMemoryBlockExtension.targetRequestFailed(e.getDetailMessage(), null);
            }
        }
    }

    private IPCDIMemoryBlock createCDIBlock(BigInteger address, long length, int wordSize) throws PCDIException {
        IPCDIMemoryBlock block = ((PDebugTarget)this.getDebugTarget()).getCDITarget().createMemoryBlock(address.toString(), (int)length, wordSize);
        block.setFrozen(false);
        this.getCDISession().getEventManager().addEventListener(this);
        return block;
    }

    private void disposeCDIBlock() {
        IPCDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            try {
                ((PDebugTarget)this.getDebugTarget()).getCDITarget().removeBlocks(new IPCDIMemoryBlock[]{block});
            }
            catch (PCDIException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
            this.setCDIBlock(null);
            this.getCDISession().getEventManager().removeEventListener(this);
        }
    }

    private IPCDIMemoryBlock getCDIBlock() {
        return this.fCDIBlock;
    }

    private void setCDIBlock(IPCDIMemoryBlock cdiBlock) {
        this.fCDIBlock = cdiBlock;
    }

    private BigInteger getRealBlockAddress() {
        IPCDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getStartAddress() : BigInteger.ZERO;
    }

    private long getBlockSize() {
        IPCDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getLength() : 0L;
    }

    private void handleChangedEvent(IPCDIMemoryChangedEvent event) {
        IPCDIMemoryBlock block = this.getCDIBlock();
        if (block != null && this.fBytes != null) {
            MemoryByte[] memBytes = (MemoryByte[])this.fBytes.clone();
            try {
                BigInteger start = this.getRealBlockAddress();
                long length = block.getLength();
                byte[] newBytes = block.getBytes();
                BigInteger[] addresses = event.getAddresses();
                this.saveChanges(addresses);
                int i = 0;
                while (i < addresses.length) {
                    int index;
                    this.fChanges.add(addresses[i]);
                    if (addresses[i].compareTo(start) >= 0 && addresses[i].compareTo(start.add(BigInteger.valueOf(length))) < 0 && (index = addresses[i].subtract(start).intValue()) >= 0 && index < memBytes.length && index < newBytes.length) {
                        memBytes[index].setChanged(true);
                        memBytes[index].setValue(newBytes[index]);
                    }
                    ++i;
                }
                this.fBytes = memBytes;
                this.fireChangeEvent(512);
            }
            catch (PCDIException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
        }
    }

    private void saveChanges(BigInteger[] addresses) {
        this.fChanges.addAll((Collection)Arrays.asList(addresses));
    }

    private boolean hasChanged(BigInteger address) {
        return this.fChanges.contains(address);
    }

    private void resetChanges() {
        if (this.fBytes != null) {
            BigInteger[] changes = this.fChanges.toArray(new BigInteger[this.fChanges.size()]);
            int i = 0;
            while (i < changes.length) {
                int index;
                BigInteger real = this.getRealBlockAddress();
                if (real.compareTo(changes[i]) <= 0 && real.add(BigInteger.valueOf(this.getBlockSize())).compareTo(changes[i]) > 0 && (index = changes[i].subtract(real).intValue()) >= 0 && index < this.fBytes.length) {
                    this.fBytes[index].setChanged(false);
                }
                ++i;
            }
        }
        this.fChanges.clear();
        this.fireChangeEvent(512);
    }

    public boolean supportsChangeManagement() {
        return true;
    }

    public void connect(Object object) {
    }

    public void disconnect(Object object) {
    }

    public Object[] getConnections() {
        return new Object[0];
    }

    public void dispose() {
        this.fChanges.clear();
        IPCDIMemoryBlock cdiBlock = this.getCDIBlock();
        if (cdiBlock != null) {
            try {
                ((PDebugTarget)this.getDebugTarget()).getCDITarget().removeBlocks(new IPCDIMemoryBlock[]{cdiBlock});
            }
            catch (PCDIException e) {
                PTPDebugCorePlugin.log((Throwable)((Object)e));
            }
            this.fCDIBlock = null;
        }
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public Object getAdapter(Class adapter) {
        if (IMemoryBlockRetrieval.class.equals((Object)adapter)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        IPCDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            BigInteger length = new BigInteger(Long.toHexString(block.getLength()), 16);
            return length;
        }
        return BigInteger.ZERO;
    }

    private MemoryByte createMemoryByte(byte value, byte cdiFlags, boolean changed) {
        byte flags = 0;
        if ((cdiFlags & 2) != 0) {
            flags = (byte)(flags | 0x28);
            flags = (cdiFlags & 1) != 0 ? (byte)(flags | 2) : (byte)(flags | 3);
            if (this.isBigEndian()) {
                flags = (byte)(flags | 0x10);
            }
            if (changed) {
                flags = (byte)(flags | 4);
            }
        }
        return new MemoryByte(value, flags);
    }
}

