/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.IJumpToAddress;
import org.eclipse.cdt.debug.core.model.IJumpToLine;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointHit;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointManager;
import org.eclipse.ptp.debug.core.cdi.IPCDIEndSteppingRange;
import org.eclipse.ptp.debug.core.cdi.IPCDISessionObject;
import org.eclipse.ptp.debug.core.cdi.IPCDISignalReceived;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIChangedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDestroyedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIBreakpoint;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDummyStackFrame;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPThread;
import org.eclipse.ptp.debug.core.model.IResumeWithoutSignal;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PDummyStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;

public class PThread
extends PDebugElement
implements IPThread,
IRestart,
IResumeWithoutSignal,
IPCDIEventListener {
    private static final int MAX_STACK_DEPTH = 100;
    private IPCDIThread fCDIThread;
    private ArrayList fStackFrames;
    private boolean fRefreshChildren = true;
    private IPCDITargetConfiguration fConfig;
    private boolean fIsCurrent = false;
    private int fLastStackDepth = 0;
    private boolean fDisposed = false;

    public PThread(PDebugTarget target, IPCDIThread cdiThread) {
        super(target);
        this.setCDIThread(cdiThread);
        if (cdiThread.isSuspended()) {
            this.setState(PDebugElementState.SUSPENDED);
            this.setCurrent(true);
        } else {
            this.setState(PDebugElementState.RESUMED);
        }
        this.fConfig = this.getCDITarget().getConfiguration();
        this.initialize();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.fStackFrames = new ArrayList();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = Collections.EMPTY_LIST;
        try {
            list = this.computeStackFrames();
        }
        catch (DebugException e) {
            this.setStatus(2, e.getStatus().getMessage());
            throw e;
        }
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return true;
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = new ArrayList();
            } else if (refreshChildren) {
                IPCDIStackFrame[] frames;
                int depth;
                Object frame;
                if (this.fStackFrames.size() > 0 && (frame = this.fStackFrames.get(this.fStackFrames.size() - 1)) instanceof IPDummyStackFrame) {
                    this.fStackFrames.remove(frame);
                }
                IPCDIStackFrame[] iPCDIStackFrameArray = (depth = this.getStackDepth()) != 0 ? this.getCDIStackFrames(0, depth > this.getMaxStackDepth() ? this.getMaxStackDepth() : depth) : (frames = new IPCDIStackFrame[]{});
                if (this.fStackFrames.isEmpty()) {
                    if (frames.length > 0) {
                        this.addStackFrames(frames, 0, frames.length);
                    }
                } else if (depth < this.getLastStackDepth()) {
                    this.disposeStackFrames(0, this.getLastStackDepth() - depth);
                    if (frames.length > 0) {
                        this.updateStackFrames(frames, 0, this.fStackFrames, this.fStackFrames.size());
                        if (this.fStackFrames.size() < frames.length) {
                            this.addStackFrames(frames, this.fStackFrames.size(), frames.length - this.fStackFrames.size());
                        }
                    }
                } else if (depth > this.getLastStackDepth()) {
                    this.disposeStackFrames(frames.length - depth + this.getLastStackDepth(), depth - this.getLastStackDepth());
                    this.addStackFrames(frames, 0, depth - this.getLastStackDepth());
                    this.updateStackFrames(frames, depth - this.getLastStackDepth(), this.fStackFrames, frames.length - depth + this.getLastStackDepth());
                } else if (depth != 0) {
                    IPCDIStackFrame oldTopFrame;
                    IPCDIStackFrame newTopFrame = frames.length > 0 ? frames[0] : null;
                    IPCDIStackFrame iPCDIStackFrame = oldTopFrame = this.fStackFrames.size() > 0 ? ((PStackFrame)this.fStackFrames.get(0)).getLastCDIStackFrame() : null;
                    if (!PStackFrame.equalFrame(newTopFrame, oldTopFrame)) {
                        this.disposeStackFrames(0, this.fStackFrames.size());
                        this.addStackFrames(frames, 0, frames.length);
                    } else {
                        this.updateStackFrames(frames, 0, this.fStackFrames, frames.length);
                    }
                }
                if (depth > this.getMaxStackDepth()) {
                    this.fStackFrames.add(new PDummyStackFrame(this));
                }
                this.setLastStackDepth(depth);
                this.setRefreshChildren(false);
            }
        }
        return this.fStackFrames;
    }

    protected IPCDIStackFrame[] getCDIStackFrames() throws DebugException {
        return new IPCDIStackFrame[0];
    }

    protected IPCDIStackFrame[] getCDIStackFrames(int lowFrame, int highFrame) throws DebugException {
        try {
            return this.getCDIThread().getStackFrames(lowFrame, highFrame);
        }
        catch (PCDIException e) {
            this.setStatus(1, MessageFormat.format(CoreModelMessages.getString("PThread.0"), e.getMessage()));
            PThread.targetRequestFailed(e.getMessage(), null);
            return new IPCDIStackFrame[0];
        }
    }

    protected void updateStackFrames(IPCDIStackFrame[] newFrames, int offset, List oldFrames, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            PStackFrame frame = (PStackFrame)oldFrames.get(offset);
            frame.setCDIStackFrame(newFrames[offset]);
            ++offset;
            ++i;
        }
    }

    protected void addStackFrames(IPCDIStackFrame[] newFrames, int startIndex, int length) {
        if (newFrames.length >= startIndex + length) {
            int i = 0;
            while (i < length) {
                this.fStackFrames.add(i, new PStackFrame(this, newFrames[startIndex + i]));
                ++i;
            }
        }
    }

    public List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames(int depth, IPCDIStackFrame[] frames) throws DebugException {
        ArrayList<PDebugElement> list = new ArrayList<PDebugElement>(frames.length);
        int i = 0;
        while (i < frames.length) {
            list.add(new PStackFrame(this, frames[i]));
            ++i;
        }
        if (depth > frames.length) {
            list.add(new PDummyStackFrame(this));
        }
        return list;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List c = this.computeStackFrames();
        return c.isEmpty() ? null : (IStackFrame)c.get(0);
    }

    public String getName() throws DebugException {
        if (this.getCDIThread() == null) {
            return "";
        }
        return this.getCDIThread().toString();
    }

    public IBreakpoint[] getBreakpoints() {
        ArrayList<IPBreakpoint> list = new ArrayList<IPBreakpoint>(1);
        if (this.isSuspended()) {
            IPBreakpoint bkpt = null;
            IPCDIBreakpointManager bManager = this.getCDISession().getBreakpointManager();
            if (this.getCurrentStateInfo() instanceof IPCDIBreakpointHit) {
                bkpt = bManager.findBreakpoint(((IPCDIBreakpointHit)this.getCurrentStateInfo()).getBreakpoint());
            }
            if (bkpt != null) {
                list.add(bkpt);
            }
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            IPCDIEvent event = events[i];
            if (!event.containTask(this.getCDITarget().getTargetID())) {
                return;
            }
            IPCDIObject source = event.getSource(this.getCDITarget().getTargetID());
            if (source instanceof IPCDIThread && source.equals(this.getCDIThread())) {
                if (event instanceof IPCDISuspendedEvent) {
                    this.handleSuspendedEvent((IPCDISuspendedEvent)event);
                } else if (event instanceof IPCDIResumedEvent) {
                    this.handleResumedEvent((IPCDIResumedEvent)event);
                } else if (event instanceof IPCDIDestroyedEvent) {
                    this.handleTerminatedEvent((IPCDIDestroyedEvent)event);
                } else if (event instanceof IPCDIDisconnectedEvent) {
                    this.handleDisconnectedEvent((IPCDIDisconnectedEvent)event);
                } else if (event instanceof IPCDIChangedEvent) {
                    this.handleChangedEvent((IPCDIChangedEvent)event);
                }
            }
            ++i;
        }
    }

    public boolean canResume() {
        return this.fConfig.supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        PDebugElementState state = this.getState();
        return this.fConfig.supportsSuspend() && (state.equals(PDebugElementState.RESUMED) || state.equals(PDebugElementState.STEPPED));
    }

    public boolean isSuspended() {
        return this.getState().equals(PDebugElementState.SUSPENDED);
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.RESUMING);
        try {
            this.getCDIThread().resume(false);
        }
        catch (PCDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.SUSPENDING);
        try {
            this.getCDIThread().suspend();
        }
        catch (CDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        if (!this.fConfig.supportsStepping() || !this.canResume()) {
            return false;
        }
        return this.fStackFrames.size() > 1;
    }

    protected boolean canStep() {
        if (!this.fConfig.supportsStepping() || !this.isSuspended()) {
            return false;
        }
        return !this.fStackFrames.isEmpty();
    }

    public boolean isStepping() {
        return this.getState().equals(PDebugElementState.STEPPING) || this.getState().equals(PDebugElementState.STEPPED);
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getCDIThread().stepInto(1);
            } else {
                this.getCDIThread().stepIntoInstruction(1);
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            if (!this.isInstructionsteppingEnabled()) {
                this.getCDIThread().stepOver(1);
            } else {
                this.getCDIThread().stepOverInstruction(1);
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            PThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length == 0) {
            return;
        }
        PStackFrame f = (PStackFrame)frames[0];
        PDebugElementState oldState = this.getState();
        this.setState(PDebugElementState.STEPPING);
        try {
            f.doStepReturn();
        }
        catch (DebugException e) {
            this.setState(oldState);
            throw e;
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setCDIThread(IPCDIThread cdiThread) {
        this.fCDIThread = cdiThread;
    }

    protected IPCDIThread getCDIThread() {
        return this.fCDIThread;
    }

    protected synchronized void preserveStackFrames() {
        Iterator it = this.fStackFrames.iterator();
        while (it.hasNext()) {
            PStackFrame frame = (PStackFrame)((IAdaptable)it.next()).getAdapter(PStackFrame.class);
            if (frame == null) continue;
            frame.preserve();
        }
        this.setRefreshChildren(true);
    }

    protected synchronized void disposeStackFrames() {
        for (Object obj : this.fStackFrames) {
            if (!(obj instanceof PStackFrame)) continue;
            ((PStackFrame)obj).dispose();
        }
        this.fStackFrames.clear();
        this.setLastStackDepth(0);
        this.resetStatus();
        this.setRefreshChildren(true);
    }

    protected void disposeStackFrames(int index, int length) {
        ArrayList<PStackFrame> removeList = new ArrayList<PStackFrame>(length);
        Iterator it = this.fStackFrames.iterator();
        int counter = 0;
        while (it.hasNext()) {
            PStackFrame frame = (PStackFrame)((IAdaptable)it.next()).getAdapter(PStackFrame.class);
            if (frame != null && counter >= index && counter < index + length) {
                frame.dispose();
                removeList.add(frame);
            }
            ++counter;
        }
        this.fStackFrames.removeAll(removeList);
    }

    protected void terminated() {
        this.setState(PDebugElementState.TERMINATED);
        this.dispose();
    }

    private void handleSuspendedEvent(IPCDISuspendedEvent event) {
        if (!(this.getState().equals(PDebugElementState.RESUMED) || this.getState().equals(PDebugElementState.STEPPED) || this.getState().equals(PDebugElementState.SUSPENDING))) {
            return;
        }
        this.setState(PDebugElementState.SUSPENDED);
        IPCDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        if (reason instanceof IPCDIEndSteppingRange) {
            this.handleEndSteppingRange((IPCDIEndSteppingRange)reason);
        } else if (reason instanceof IPCDIBreakpoint) {
            this.handleBreakpointHit((IPCDIBreakpoint)((Object)reason));
        } else if (reason instanceof IPCDISignalReceived) {
            this.handleSuspendedBySignal((IPCDISignalReceived)reason);
        } else {
            this.fireSuspendEvent(16);
        }
    }

    private void handleResumedEvent(IPCDIResumedEvent event) {
        PDebugElementState state = PDebugElementState.RESUMED;
        int detail = 1;
        if (this.isCurrent() && event.getType() != 0) {
            this.preserveStackFrames();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    detail = 1;
                    break;
                }
                case 1: 
                case 3: {
                    detail = 2;
                    break;
                }
                case 5: {
                    detail = 4;
                }
            }
            state = PDebugElementState.STEPPING;
        } else {
            this.disposeStackFrames();
            this.fireChangeEvent(512);
        }
        this.setCurrent(false);
        this.setState(state);
        this.setCurrentStateInfo(null);
        this.fireResumeEvent(detail);
    }

    private void handleEndSteppingRange(IPCDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(8);
    }

    private void handleBreakpointHit(IPCDIBreakpoint breakpoint) {
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(IPCDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleTerminatedEvent(IPCDIDestroyedEvent event) {
        this.setState(PDebugElementState.TERMINATED);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleDisconnectedEvent(IPCDIDisconnectedEvent event) {
        this.setState(PDebugElementState.TERMINATED);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleChangedEvent(IPCDIChangedEvent event) {
    }

    protected void cleanup() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
    }

    private void setRefreshChildren(boolean refresh) {
        this.fRefreshChildren = refresh;
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected void setCurrent(boolean current) {
        this.fIsCurrent = current;
    }

    protected int getStackDepth() throws DebugException {
        int depth = 0;
        try {
            depth = this.getCDIThread().getStackFrameCount();
        }
        catch (PCDIException e) {
            this.setStatus(1, MessageFormat.format(CoreModelMessages.getString("PThread.1"), e.getMessage()));
        }
        return depth;
    }

    protected int getMaxStackDepth() {
        return 100;
    }

    private void setLastStackDepth(int depth) {
        this.fLastStackDepth = depth;
    }

    protected int getLastStackDepth() {
        return this.fLastStackDepth;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IRunToLine.class) || adapter.equals(IRunToAddress.class) || adapter.equals(IJumpToLine.class) || adapter.equals(IJumpToAddress.class)) {
            try {
                return (IPStackFrame)this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter.equals(PDebugElementState.class)) {
            return this;
        }
        if (adapter == IPStackFrame.class) {
            try {
                return (IPStackFrame)this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.fDisposed = true;
        this.cleanup();
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    protected void resumedByTarget(int detail, List events) {
        if (this.isCurrent() && detail != 32 && detail != 0) {
            this.setState(PDebugElementState.STEPPED);
            this.preserveStackFrames();
            events.add(this.createResumeEvent(detail));
        } else {
            this.setState(PDebugElementState.RESUMED);
            this.disposeStackFrames();
            events.add(this.createChangeEvent(512));
        }
        this.setCurrent(false);
        this.setCurrentStateInfo(null);
    }

    protected boolean isInstructionsteppingEnabled() {
        return ((PDebugTarget)this.getDebugTarget()).isInstructionSteppingEnabled();
    }

    protected void suspendByTarget(IPCDISessionObject reason, IPCDIThread suspensionThread) {
        this.setState(PDebugElementState.SUSPENDED);
        this.setCurrentStateInfo(null);
        if (this.getCDIThread().equals(suspensionThread)) {
            this.setCurrent(true);
            this.setCurrentStateInfo(reason);
            if (reason instanceof IPCDIEndSteppingRange) {
                this.handleEndSteppingRange((IPCDIEndSteppingRange)reason);
            } else if (reason instanceof IPCDIBreakpoint) {
                this.handleBreakpointHit((IPCDIBreakpoint)((Object)reason));
            } else if (reason instanceof IPCDISignalReceived) {
                this.handleSuspendedBySignal((IPCDISignalReceived)reason);
            } else {
                this.fireSuspendEvent(16);
            }
        }
    }
}

