/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PDOMTypeReference
implements ITypeReference {
    private final PDOMName name;
    private final ICProject project;
    private final IPath path;

    public PDOMTypeReference(PDOMName name, ICProject project) {
        this.name = name;
        this.project = project;
        this.path = new Path(name.getFileLocation().getFileName());
    }

    public ICElement[] getCElements() {
        throw new PDOMNotImplementedError();
    }

    public int getLength() {
        return this.name.getFileLocation().getNodeLength();
    }

    public IPath getLocation() {
        return this.path;
    }

    public int getOffset() {
        return this.name.getFileLocation().getNodeOffset();
    }

    public IPath getPath() {
        return this.path;
    }

    public IProject getProject() {
        throw new PDOMNotImplementedError();
    }

    public IPath getRelativeIncludePath(IProject project) {
        throw new PDOMNotImplementedError();
    }

    public IPath getRelativePath(IPath relativeToPath) {
        throw new PDOMNotImplementedError();
    }

    public IResource getResource() {
        throw new PDOMNotImplementedError();
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement element = CoreModel.getDefault().create(this.path);
        if (element != null && element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return CoreModel.getDefault().createTranslationUnitFrom(this.project, this.path);
    }

    public IWorkingCopy getWorkingCopy() {
        throw new PDOMNotImplementedError();
    }

    public boolean isLineNumber() {
        return this.name.getFileLocation().getNodeLength() == -1;
    }
}

