/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICDescriptorManager;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.internal.core.CDescriptor;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.COwnerConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class CDescriptorManager
implements ICDescriptorManager,
IResourceChangeListener {
    Map fOperationMap = new HashMap(1);
    Map fDescriptorMap = new HashMap();
    Map fOwnerConfigMap = null;
    List listeners = Collections.synchronizedList(new Vector());
    private static final COwnerConfiguration NULLCOwner = new COwnerConfiguration("", CCorePlugin.getResourceString("CDescriptorManager.internal_owner"));

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void startup() throws CoreException {
        this.getWorkspace().getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.getType() == 4) {
                    IProject project = (IProject)resource;
                    try {
                        if (project.isAccessible() && project.findMember(".cdtproject") != null) {
                            CDescriptorManager.this.getDescriptor(project);
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    return false;
                }
                return resource.getType() == 8;
            }
        });
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 14);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    CDescriptor descriptor;
                    if (resource.getType() != 4 || (descriptor = (CDescriptor)this.fDescriptorMap.remove(resource)) == null) break;
                    this.fireEvent(new CDescriptorEvent(descriptor, 3, 0));
                    break;
                }
                case 8: {
                    IResourceDelta resDelta = event.getDelta();
                    if (resDelta == null) break;
                    try {
                        resDelta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource dResource = delta.getResource();
                                if (dResource.getType() == 4) {
                                    if ((delta.getFlags() & 0x4000) != 0) {
                                        IProject project = (IProject)dResource;
                                        if (project.isAccessible() && project.findMember(".cdtproject") != null && CDescriptorManager.this.fDescriptorMap.get(project) == null) {
                                            CDescriptorManager.this.getDescriptor(project);
                                        } else {
                                            CDescriptor descriptor = (CDescriptor)CDescriptorManager.this.fDescriptorMap.remove(project);
                                            if (descriptor != null) {
                                                CDescriptorManager.this.fireEvent(new CDescriptorEvent(descriptor, 3, 0));
                                            }
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                                if (dResource.getType() == 1) {
                                    if (dResource.getName().equals(".cdtproject")) {
                                        CDescriptor descriptor = (CDescriptor)CDescriptorManager.this.fDescriptorMap.get(dResource.getProject());
                                        if (descriptor != null) {
                                            if ((delta.getKind() & 2) != 0) {
                                                descriptor.updateOnDisk();
                                            } else if ((delta.getFlags() & 0x100) != 0) {
                                                descriptor.updateFromDisk();
                                            }
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                                return dResource.getType() == 8;
                            }
                        });
                        break;
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
        }
    }

    private void initializeOwnerConfiguration() {
        IExtensionPoint extpoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CProject");
        IExtension[] extension = extpoint.getExtensions();
        this.fOwnerConfigMap = new HashMap(extension.length);
        int i = 0;
        while (i < extension.length) {
            IConfigurationElement[] element = extension[i].getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                if (element[j].getName().equalsIgnoreCase("cproject")) {
                    this.fOwnerConfigMap.put(extension[i].getUniqueIdentifier(), new COwnerConfiguration(element[j]));
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    COwnerConfiguration getOwnerConfiguration(String id) {
        COwnerConfiguration config;
        if (id.equals(NULLCOwner.getOwnerID())) {
            return NULLCOwner;
        }
        if (this.fOwnerConfigMap == null) {
            this.initializeOwnerConfiguration();
        }
        if ((config = (COwnerConfiguration)this.fOwnerConfigMap.get(id)) == null) {
            config = new COwnerConfiguration(id, CCorePlugin.getResourceString("CDescriptorManager.owner_not_Installed"));
            this.fOwnerConfigMap.put(id, config);
        }
        return config;
    }

    COwnerConfiguration getOwnerConfiguration(IProject project) throws CoreException {
        if (this.fOwnerConfigMap == null) {
            this.initializeOwnerConfiguration();
        }
        IProjectDescription description = project.getDescription();
        String[] natureIDs = description.getNatureIds();
        Iterator configs = this.fOwnerConfigMap.entrySet().iterator();
        while (configs.hasNext()) {
            Map.Entry entry = configs.next();
            COwnerConfiguration config = (COwnerConfiguration)entry.getValue();
            if (config.getNature() == null || Arrays.asList(natureIDs).lastIndexOf(config.getNature()) == -1) continue;
            return config;
        }
        return NULLCOwner;
    }

    public synchronized ICDescriptor getDescriptor(IProject project) throws CoreException {
        return this.getDescriptor(project, true);
    }

    public synchronized ICDescriptor getDescriptor(IProject project, boolean create) throws CoreException {
        CDescriptor descriptor = (CDescriptor)this.fDescriptorMap.get(project);
        if (descriptor == null) {
            if (create) {
                descriptor = new CDescriptor(this, project);
                this.fDescriptorMap.put(project, descriptor);
            } else {
                IPath descriptionPath;
                IPath projectLocation = project.getDescription().getLocation();
                if (projectLocation == null) {
                    projectLocation = Platform.getLocation().append(project.getFullPath());
                }
                if ((descriptionPath = projectLocation.append(".cdtproject")).toFile().exists()) {
                    descriptor = new CDescriptor(this, project);
                    this.fDescriptorMap.put(project, descriptor);
                }
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configure(IProject project, String id) throws CoreException {
        CDescriptor descriptor;
        if (id.equals(NULLCOwner.getOwnerID())) {
            Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.invalid_ownerID"), null);
            throw new CoreException((IStatus)status);
        }
        CDescriptorManager cDescriptorManager = this;
        synchronized (cDescriptorManager) {
            block11: {
                descriptor = (CDescriptor)this.fDescriptorMap.get(project);
                if (descriptor != null) {
                    if (descriptor.getProjectOwner().getID().equals(NULLCOwner.getOwnerID())) {
                        descriptor = new CDescriptor(this, project, new COwner(this.getOwnerConfiguration(id)));
                        break block11;
                    } else {
                        if (!descriptor.getProjectOwner().getID().equals(id)) {
                            Status status = new Status(4, "org.eclipse.cdt.core", 1, CCorePlugin.getResourceString("CDescriptorManager.exception.alreadyConfigured"), null);
                            throw new CoreException((IStatus)status);
                        }
                        return;
                    }
                }
                try {
                    descriptor = new CDescriptor(this, project, id);
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status.getCode() != 1) {
                        throw e;
                    }
                    descriptor = new CDescriptor(this, project);
                }
            }
            this.fDescriptorMap.put(project, descriptor);
        }
        this.fireEvent(new CDescriptorEvent(descriptor, 2, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(IProject project, String id) throws CoreException {
        CDescriptor descriptor;
        CDescriptorManager cDescriptorManager = this;
        synchronized (cDescriptorManager) {
            descriptor = new CDescriptor(this, project, new COwner(this.getOwnerConfiguration(id)));
            this.fDescriptorMap.put(project, descriptor);
        }
        this.fireEvent(new CDescriptorEvent(descriptor, 1, 16));
    }

    public void addDescriptorListener(ICDescriptorListener listener) {
        this.listeners.add(listener);
    }

    public void removeDescriptorListener(ICDescriptorListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(final CDescriptorEvent event) {
        ICDescriptorListener[] listener;
        if (this.fOperationMap.containsKey(event.getDescriptor())) {
            if (event.getType() == 2) {
                this.fOperationMap.put(event.getDescriptor(), event);
            } else if (event.getType() == 3) {
                this.fOperationMap.put(event.getDescriptor(), event);
            } else {
                CDescriptorEvent ev = (CDescriptorEvent)this.fOperationMap.get(event.getDescriptor());
                if (ev == null) {
                    this.fOperationMap.put(event.getDescriptor(), event);
                } else if ((ev.getFlags() & event.getFlags()) != event.getFlags()) {
                    this.fOperationMap.put(event.getDescriptor(), new CDescriptorEvent(event.getDescriptor(), event.getType(), ev.getFlags() | event.getFlags()));
                }
            }
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            listener = this.listeners.toArray(new ICDescriptorListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < listener.length) {
            final int index = i++;
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString("CDescriptorManager.exception.listenerError"), exception);
                    CCorePlugin.log((IStatus)status);
                }

                public void run() throws Exception {
                    listener[index].descriptorChanged(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runDescriptorOperation(IProject project, ICDescriptorOperation op, IProgressMonitor monitor) throws CoreException {
        ICDescriptor descriptor = this.getDescriptor(project, true);
        if (descriptor == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", -1, "Failed to create descriptor", null));
        }
        CDescriptorEvent event = null;
        ICDescriptor iCDescriptor = descriptor;
        synchronized (iCDescriptor) {
            this.beginOperation(descriptor);
            try {
                op.execute(descriptor, monitor);
                Object var7_9 = null;
                event = this.endOperation(descriptor);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                event = this.endOperation(descriptor);
                throw throwable;
            }
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    private void beginOperation(ICDescriptor descriptor) {
        this.fOperationMap.put(descriptor, null);
    }

    private CDescriptorEvent endOperation(ICDescriptor descriptor) {
        return (CDescriptorEvent)this.fOperationMap.remove(descriptor);
    }

    protected void updateDescriptor(CDescriptor descriptor) {
        new CDescriptorUpdater(descriptor).schedule();
    }

    class CDescriptorUpdater
    extends Job {
        CDescriptor fDescriptor;

        public CDescriptorUpdater(CDescriptor descriptor) {
            super(CCorePlugin.getResourceString("CDescriptorManager.async_updater"));
            this.fDescriptor = descriptor;
            this.setPriority(10);
            this.setSystem(true);
            this.setRule((ISchedulingRule)descriptor.getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.fDescriptor.save();
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

