/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

public class SetPathEntriesOperation
extends CModelOperation {
    static final String[] NO_PREREQUISITES = new String[0];
    IPathEntry[] oldResolvedEntries;
    IPathEntry[] newRawEntries;
    ICProject cproject;

    public SetPathEntriesOperation(ICProject project, IPathEntry[] oldResolvedEntries, IPathEntry[] newRawEntries) {
        super(project);
        this.oldResolvedEntries = oldResolvedEntries;
        this.newRawEntries = newRawEntries;
        this.cproject = project;
    }

    protected void executeOperation() throws CModelException {
        this.updateProjectReferencesIfNecessary();
        PathEntryManager mgr = PathEntryManager.getDefault();
        this.hasModifiedResource = true;
        mgr.saveRawPathEntries(this.cproject, this.newRawEntries);
        this.done();
    }

    protected void updateProjectReferencesIfNecessary() throws CModelException {
        PathEntryManager mgr = PathEntryManager.getDefault();
        String[] oldRequired = mgr.projectPrerequisites(this.oldResolvedEntries);
        String[] newRequired = mgr.projectPrerequisites(this.newRawEntries);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject projectResource;
            block10: {
                String projectName;
                projectResource = this.cproject.getProject();
                description = projectResource.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block10;
                    }
                    return;
                }
            }
            Object[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Arrays.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject((String)requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            projectResource.setDescription(description, this.fMonitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }
}

