/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.BacktrackException;
import org.eclipse.cdt.internal.core.parser.Declarator;
import org.eclipse.cdt.internal.core.parser.IDeclaratorOwner;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;

public class DeclarationWrapper
implements IDeclaratorOwner {
    private int flag = 0;
    private static final int DEFAULT_LIST_SIZE = 4;
    protected static final int IS_IMAGINARY = 16;
    protected static final int IS_COMPLEX = 32;
    protected static final int IS_RESTRICT = 64;
    protected static final int IS_SIGNED = 128;
    protected static final int IS_SHORT = 256;
    protected static final int IS_UNSIGNED = 512;
    protected static final int IS_LONG = 1024;
    protected static final int IS_TYPENAMED = 2048;
    protected static final int IS_VOLATILE = 4096;
    protected static final int IS_VIRTUAL = 8192;
    protected static final int IS_TYPEDEF = 16384;
    protected static final int IS_STATIC = 32768;
    protected static final int IS_REGISTER = 65536;
    protected static final int IS_EXTERN = 131072;
    protected static final int IS_EXPLICIT = 262144;
    protected static final int IS_CONST = 524288;
    protected static final int IS_AUTO = 0x100000;
    protected static final int IS_GLOBAL = 0x200000;
    protected static final int IS_MUTABLE = 0x400000;
    protected static final int IS_FRIEND = 0x800000;
    protected static final int IS_INLINE = 0x1000000;
    private int startingOffset = 0;
    private int startingLine;
    private int endOffset;
    private ITokenDuple name;
    private IASTSimpleTypeSpecifier.Type simpleType = IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    private final IASTTemplate templateDeclaration;
    private final IASTScope scope;
    private IASTTypeSpecifier typeSpecifier;
    private List declarators = Collections.EMPTY_LIST;
    private IASTFactory astFactory = null;
    private int endLine;
    private final char[] fn;
    private Map extensionParameters = Collections.EMPTY_MAP;

    protected void setBit(boolean b, int mask) {
        this.flag = b ? (this.flag |= mask) : (this.flag &= ~mask);
    }

    protected boolean checkBit(int mask) {
        return (this.flag & mask) != 0;
    }

    public void setAuto(boolean b) {
        this.setBit(b, 0x100000);
    }

    public IASTScope getScope() {
        return this.scope;
    }

    public DeclarationWrapper(IASTScope scope, int startingOffset, int startingLine, IASTTemplate templateDeclaration, char[] filename) {
        this.scope = scope;
        this.startingOffset = startingOffset;
        this.startingLine = startingLine;
        this.templateDeclaration = templateDeclaration;
        this.fn = filename;
    }

    public void setTypenamed(boolean b) {
        this.setBit(b, 2048);
    }

    public void setMutable(boolean b) {
        this.setBit(b, 0x400000);
    }

    public void setFriend(boolean b) {
        this.setBit(b, 0x800000);
    }

    public void setInline(boolean b) {
        this.setBit(b, 0x1000000);
    }

    public void setRegister(boolean b) {
        this.setBit(b, 65536);
    }

    public void setStatic(boolean b) {
        this.setBit(b, 32768);
    }

    public void setTypedef(boolean b) {
        this.setBit(b, 16384);
    }

    public void setVirtual(boolean b) {
        this.setBit(b, 8192);
    }

    public void setVolatile(boolean b) {
        this.setBit(b, 4096);
    }

    public void setExtern(boolean b) {
        this.setBit(b, 131072);
    }

    public void setExplicit(boolean b) {
        this.setBit(b, 262144);
    }

    public void setConst(boolean b) {
        this.setBit(b, 524288);
    }

    public boolean isAuto() {
        return this.checkBit(0x100000);
    }

    public boolean isConst() {
        return this.checkBit(524288);
    }

    public boolean isExplicit() {
        return this.checkBit(262144);
    }

    public boolean isExtern() {
        return this.checkBit(131072);
    }

    public boolean isFriend() {
        return this.checkBit(0x800000);
    }

    public boolean isInline() {
        return this.checkBit(0x1000000);
    }

    public boolean isMutable() {
        return this.checkBit(0x400000);
    }

    public boolean isRegister() {
        return this.checkBit(65536);
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getStartingLine() {
        return this.startingLine;
    }

    public boolean isStatic() {
        return this.checkBit(32768);
    }

    public boolean isTypedef() {
        return this.checkBit(16384);
    }

    public boolean isTypeNamed() {
        return this.checkBit(2048);
    }

    public boolean isVirtual() {
        return this.checkBit(8192);
    }

    public boolean isVolatile() {
        return this.checkBit(4096);
    }

    public void addDeclarator(Declarator d) {
        if (this.declarators == Collections.EMPTY_LIST) {
            this.declarators = new ArrayList(4);
        }
        this.declarators.add(d);
    }

    public Iterator getDeclarators() {
        return this.declarators.iterator();
    }

    private List getDeclaratorsList() {
        return this.declarators;
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public void setTypeSpecifier(IASTTypeSpecifier specifier) {
        this.typeSpecifier = specifier;
    }

    public List createASTNodes(IASTFactory astFactoryToWorkWith) throws ASTSemanticException, BacktrackException {
        this.astFactory = astFactoryToWorkWith;
        if (this.declarators.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IASTDeclaration> l = new ArrayList<IASTDeclaration>(this.declarators.size());
        int i = 0;
        while (i < this.declarators.size()) {
            l.add(this.createASTNode((Declarator)this.declarators.get(i)));
            ++i;
        }
        return l;
    }

    private IASTDeclaration createASTNode(Declarator declarator) throws ASTSemanticException, BacktrackException {
        boolean hasInnerDeclarator;
        boolean isWithinClass = false;
        if (this.getScope() instanceof IASTClassSpecifier) {
            isWithinClass = true;
        } else if (this.getScope() instanceof IASTTemplateDeclaration) {
            isWithinClass = ((IASTTemplateDeclaration)this.getScope()).getOwnerScope() instanceof IASTClassSpecifier;
        }
        boolean isFunction = declarator.isFunction();
        boolean bl = hasInnerDeclarator = declarator.getOwnedDeclarator() != null;
        if (hasInnerDeclarator) {
            return this.createIndirectDeclaration(declarator);
        }
        if (this.isTypedef()) {
            return this.createTypedef(declarator, false);
        }
        if (isWithinClass) {
            if (isFunction) {
                return this.createMethodASTNode(declarator, false);
            }
            if (declarator.hasFunctionBody()) {
                throw new ASTSemanticException(null);
            }
            return this.createFieldASTNode(declarator, false);
        }
        if (isFunction) {
            return this.createFunctionASTNode(declarator, false);
        }
        if (declarator.hasFunctionBody()) {
            throw new ASTSemanticException(null);
        }
        return this.createVariableASTNode(declarator, false);
    }

    private IASTDeclaration createIndirectDeclaration(Declarator declarator) throws BacktrackException, ASTSemanticException {
        if (declarator.getOwnedDeclarator().getOwnedDeclarator() == null) {
            ITokenDuple nameDuple;
            boolean isFunction;
            Declarator d = declarator.getOwnedDeclarator();
            List ptrOps = d.getPointerOperators();
            boolean isWithinClass = this.scope instanceof IASTClassSpecifier;
            boolean bl = isFunction = declarator.getParameters().size() != 0;
            if (ptrOps.size() == 0) {
                if (this.isTypedef()) {
                    return this.createTypedef(declarator, true);
                }
                if (isWithinClass) {
                    if (isFunction) {
                        return this.createMethodASTNode(declarator, true);
                    }
                    return this.createFieldASTNode(declarator, true);
                }
                if (isFunction) {
                    return this.createFunctionASTNode(declarator, true);
                }
                return this.createVariableASTNode(declarator, true);
            }
            List convertedParms = this.createParameterList(declarator.getParameters());
            IASTAbstractDeclaration abs = null;
            abs = this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), convertedParms, (ASTPointerOperator)ptrOps.get(0));
            ITokenDuple iTokenDuple = nameDuple = d.getPointerOperatorNameDuple() != null ? TokenFactory.createTokenDuple(d.getPointerOperatorNameDuple(), d.getNameDuple()) : d.getNameDuple();
            if (this.isTypedef()) {
                return this.astFactory.createTypedef(this.scope, nameDuple.toCharArray(), abs, this.getStartingOffset(), this.getStartingLine(), d.getNameStartOffset(), d.getNameEndOffset(), d.getNameLine(), this.fn);
            }
            if (isWithinClass) {
                return this.astFactory.createField(this.scope, nameDuple, this.isAuto(), d.getInitializerClause(), d.getBitFieldExpression(), abs, this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), d.getNameStartOffset(), d.getNameEndOffset(), d.getNameLine(), d.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), this.fn);
            }
            return this.astFactory.createVariable(this.scope, nameDuple, this.isAuto(), d.getInitializerClause(), d.getBitFieldExpression(), abs, this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), d.getNameStartOffset(), d.getNameEndOffset(), d.getNameLine(), d.getConstructorExpression(), this.fn);
        }
        throw new BacktrackException();
    }

    private IASTTypedefDeclaration createTypedef(Declarator declarator, boolean nested) throws ASTSemanticException {
        return this.astFactory.createTypedef(this.scope, nested ? declarator.getOwnedDeclarator().getName() : declarator.getName(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.fn);
    }

    private IASTMethod createMethodASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        IASTScope classifierScope = this.getScope();
        if (classifierScope instanceof IASTTemplateDeclaration) {
            classifierScope = ((IASTTemplateDeclaration)classifierScope).getOwnerScope();
        }
        return this.astFactory.createMethod(this.scope, nested ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.isInline(), this.isFriend(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.isVirtual(), this.isExplicit(), declarator.isPureVirtual(), ((IASTClassSpecifier)classifierScope).getCurrentVisibilityMode(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTFunction createFunctionASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        return this.astFactory.createFunction(this.scope, nested ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.createParameterList(declarator.getParameters()), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), declarator.getExceptionSpecification(), this.isInline(), this.isFriend(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), this.templateDeclaration, declarator.isConst(), declarator.isVolatile(), this.isVirtual(), this.isExplicit(), declarator.isPureVirtual(), declarator.getConstructorMemberInitializers(), declarator.hasFunctionBody(), declarator.hasFunctionTryBlock(), declarator.isVarArgs());
    }

    private IASTField createFieldASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        return this.astFactory.createField(this.scope, nested ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.startingOffset, this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression(), ((IASTClassSpecifier)this.scope).getCurrentVisibilityMode(), this.fn);
    }

    private List createParameterList(List currentParameters) throws ASTSemanticException {
        if (currentParameters.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IASTParameterDeclaration> result = new ArrayList<IASTParameterDeclaration>(currentParameters.size());
        int i = 0;
        while (i < currentParameters.size()) {
            DeclarationWrapper wrapper = (DeclarationWrapper)currentParameters.get(i);
            List decls = wrapper.getDeclaratorsList();
            int j = 0;
            while (j < decls.size()) {
                Declarator declarator = (Declarator)decls.get(j);
                result.add(this.astFactory.createParameterDeclaration(wrapper.isConst(), wrapper.isVolatile(), wrapper.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null, declarator.getName(), declarator.getInitializerClause(), wrapper.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), wrapper.getEndOffset(), this.getEndLine(), wrapper.fn));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private IASTVariable createVariableASTNode(Declarator declarator, boolean nested) throws ASTSemanticException {
        return this.astFactory.createVariable(this.scope, nested ? declarator.getOwnedDeclarator().getNameDuple() : declarator.getNameDuple(), this.isAuto(), declarator.getInitializerClause(), declarator.getBitFieldExpression(), this.astFactory.createAbstractDeclaration(this.isConst(), this.isVolatile(), this.getTypeSpecifier(), declarator.getPointerOperators(), declarator.getArrayModifiers(), null, null), this.isMutable(), this.isExtern(), this.isRegister(), this.isStatic(), this.getStartingOffset(), this.getStartingLine(), declarator.getNameStartOffset(), declarator.getNameEndOffset(), declarator.getNameLine(), declarator.getConstructorExpression(), this.fn);
    }

    public DeclarationWrapper getDeclarationWrapper() {
        return this;
    }

    public boolean isUnsigned() {
        return this.checkBit(512);
    }

    public boolean isSigned() {
        return this.checkBit(128);
    }

    public boolean isShort() {
        return this.checkBit(256);
    }

    public boolean isLong() {
        return this.checkBit(1024);
    }

    public void setLong(boolean b) {
        this.setBit(b, 1024);
    }

    public void setShort(boolean b) {
        this.setBit(b, 256);
    }

    public void setSigned(boolean b) {
        this.setBit(b, 128);
    }

    public void setUnsigned(boolean b) {
        this.setBit(b, 512);
    }

    public IASTSimpleTypeSpecifier.Type getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(IASTSimpleTypeSpecifier.Type type) {
        this.simpleType = type;
    }

    public void setTypeName(ITokenDuple duple) {
        this.name = duple;
    }

    public final ITokenDuple getName() {
        return this.name;
    }

    public final IASTTemplate getOwnerTemplate() {
        return this.templateDeclaration;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endOffset = offset;
        this.endLine = lineNumber;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setRestrict(boolean b) {
        this.setBit(b, 64);
    }

    public boolean isRestrict() {
        return this.checkBit(64);
    }

    public void setImaginary(boolean b) {
        this.setBit(b, 16);
    }

    public boolean isComplex() {
        return this.checkBit(32);
    }

    public boolean isImaginary() {
        return this.checkBit(16);
    }

    public void setComplex(boolean b) {
        this.setBit(b, 32);
    }

    public void setGloballyQualified(boolean b) {
        this.setBit(b, 0x200000);
    }

    public boolean isGloballyQualified() {
        return this.checkBit(0x200000);
    }

    public void setExtensionParameter(String key, Object value) {
        if (this.extensionParameters == Collections.EMPTY_MAP) {
            this.extensionParameters = new Hashtable(4);
        }
        this.extensionParameters.put(key, value);
    }

    public Map getExtensionParameters() {
        return this.extensionParameters;
    }

    public boolean consumedRawType() {
        return this.getSimpleType() != IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    }
}

