/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTUsingDeclaration
extends ASTDeclaration
implements IASTUsingDeclaration {
    private final boolean isTypename;
    private final char[] mappingName;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLine;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTUsingDeclaration(IASTScope scope, boolean isTypeName, char[] mappingName, int startingOffset, int startingLine, int endingOffset, int endingLine, char[] filename, int nStart, int nEnd, int nLine) {
        super(scope);
        this.isTypename = isTypeName;
        this.mappingName = mappingName;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.fn = filename;
        this.setNameOffset(nStart);
        this.setNameEndOffsetAndLineNumber(nEnd, nLine);
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public String usingTypeName() {
        return String.valueOf(this.mappingName);
    }

    public char[] usingTypeNameCharArray() {
        return this.mappingName;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptUsingDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public Iterator getUsingTypes() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public String getName() {
        return new String(this.mappingName);
    }

    public char[] getNameCharArray() {
        return this.mappingName;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLine = lineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLine;
    }
}

