/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;

public class ListItem {
    protected final Database db;
    protected final int record;
    protected static final int NEXT = 0;
    protected static final int PREV = 4;
    protected static final int ITEM = 8;
    protected static final int RECORD_SIZE = 12;

    public ListItem(Database db, int record) {
        this.db = db;
        this.record = record;
    }

    public ListItem(Database db) throws CoreException {
        this.db = db;
        this.record = db.malloc(12);
    }

    public int getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListItem) {
            return this.record == ((ListItem)obj).record;
        }
        return false;
    }

    public void setItem(int item) throws CoreException {
        this.db.putInt(this.record + 8, item);
    }

    public int getItem() throws CoreException {
        return this.db.getInt(this.record + 8);
    }

    public void setNext(ListItem next) throws CoreException {
        this.db.putInt(this.record + 0, next.getRecord());
    }

    public ListItem getNext() throws CoreException {
        int next = this.db.getInt(this.record + 0);
        return next != 0 ? new ListItem(this.db, next) : null;
    }

    public void setPrev(ListItem prev) throws CoreException {
        this.db.putInt(this.record + 4, prev.getRecord());
    }

    public ListItem getPrev() throws CoreException {
        int prev = this.db.getInt(this.record + 4);
        return prev != 0 ? new ListItem(this.db, prev) : null;
    }
}

