/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;

public class PDOMMacroParameter {
    private final PDOM pdom;
    private final int record;
    private static final int NEXT = 0;
    private static final int NAME = 4;
    private static final int RECORD_SIZE = 8;

    public PDOMMacroParameter(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMMacroParameter(PDOM pdom, String name) throws CoreException {
        Database db = pdom.getDB();
        this.pdom = pdom;
        this.record = db.malloc(8);
        db.putInt(this.record + 0, 0);
        db.putInt(this.record + 4, db.newString(name).getRecord());
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        PDOMMacroParameter next = this.getNextParameter();
        if (next != null) {
            next.delete();
        }
        this.getName().delete();
        this.pdom.getDB().free(this.record);
    }

    public void setNextParameter(PDOMMacroParameter next) throws CoreException {
        int rec = next != null ? next.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 0, rec);
    }

    public PDOMMacroParameter getNextParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 0);
        return rec != 0 ? new PDOMMacroParameter(this.pdom, rec) : null;
    }

    public IString getName() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getString(db.getInt(this.record + 4));
    }
}

