/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBasicType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPField;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPMethod;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespaceAlias;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypedef;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PDOMCPPLinkage
extends PDOMLinkage {
    public static final int CPPVARIABLE = 3;
    public static final int CPPFUNCTION = 4;
    public static final int CPPCLASSTYPE = 5;
    public static final int CPPFIELD = 6;
    public static final int CPPMETHOD = 7;
    public static final int CPPNAMESPACE = 8;
    public static final int CPPNAMESPACEALIAS = 9;
    public static final int CPPBASICTYPE = 10;
    public static final int CPPPARAMETER = 11;
    public static final int CPPENUMERATION = 12;
    public static final int CPPENUMERATOR = 13;
    public static final int CPPTYPEDEF = 14;

    public PDOMCPPLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPLinkage(PDOM pdom) throws CoreException {
        super(pdom, "org.eclipse.cdt.core.g++", "C++".toCharArray());
    }

    protected int getRecordSize() {
        return 24;
    }

    public int getNodeType() {
        return 0;
    }

    public ILanguage getLanguage() {
        return new GPPLanguage();
    }

    public PDOMNode getParent(IBinding binding) throws CoreException {
        IBinding scopeBinding;
        PDOMBinding scopePDOMBinding;
        IASTName scopeName;
        PDOMNamedNode parent = this;
        IScope scope = binding.getScope();
        if (scope != null && (scopeName = scope.getScopeName()) != null && (scopePDOMBinding = this.adaptBinding(scopeBinding = scopeName.resolveBinding())) != null) {
            parent = scopePDOMBinding;
        }
        return parent;
    }

    public PDOMBinding addName(IASTName name, PDOMFile file) throws CoreException {
        if (name == null || name instanceof ICPPASTQualifiedName) {
            return null;
        }
        char[] namechars = name.toCharArray();
        if (namechars == null || namechars.length == 0) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        if (binding instanceof IParameter) {
            return null;
        }
        PDOMBinding pdomBinding = this.adaptBinding(binding);
        if (pdomBinding == null) {
            PDOMNode parent = this.getParent(binding);
            if (binding instanceof ICPPField && parent instanceof PDOMCPPClassType) {
                pdomBinding = new PDOMCPPField(this.pdom, (PDOMCPPClassType)parent, name);
            } else if (binding instanceof ICPPVariable) {
                if (!(binding.getScope() instanceof CPPBlockScope)) {
                    pdomBinding = new PDOMCPPVariable(this.pdom, parent, name);
                }
            } else if (binding instanceof ICPPMethod && parent instanceof PDOMCPPClassType) {
                pdomBinding = new PDOMCPPMethod(this.pdom, (PDOMCPPClassType)parent, name);
            } else if (binding instanceof CPPImplicitMethod && parent instanceof PDOMCPPClassType) {
                if (!name.isReference()) {
                    pdomBinding = new PDOMCPPMethod(this.pdom, (PDOMCPPClassType)parent, name);
                }
            } else if (binding instanceof ICPPFunction) {
                pdomBinding = new PDOMCPPFunction(this.pdom, parent, name);
            } else if (binding instanceof ICPPClassType) {
                pdomBinding = new PDOMCPPClassType(this.pdom, parent, name);
            } else if (binding instanceof ICPPNamespaceAlias) {
                pdomBinding = new PDOMCPPNamespaceAlias(this.pdom, parent, name);
            } else if (binding instanceof ICPPNamespace) {
                pdomBinding = new PDOMCPPNamespace(this.pdom, parent, name);
            } else if (binding instanceof IEnumeration) {
                pdomBinding = new PDOMCPPEnumeration(this.pdom, parent, name);
            } else if (binding instanceof IEnumerator) {
                IEnumeration enumeration = (IEnumeration)((IEnumerator)binding).getType();
                PDOMBinding pdomEnumeration = this.adaptBinding(enumeration);
                if (pdomEnumeration instanceof PDOMCPPEnumeration) {
                    pdomBinding = new PDOMCPPEnumerator(this.pdom, parent, name, (PDOMCPPEnumeration)pdomEnumeration);
                }
            } else if (binding instanceof ITypedef) {
                pdomBinding = new PDOMCPPTypedef(this.pdom, parent, name, (ITypedef)binding);
            }
        }
        if (pdomBinding != null) {
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseNode;
            ICPPASTCompositeTypeSpecifier ownerNode;
            PDOMBinding ownerBinding;
            new PDOMName(this.pdom, name, file, pdomBinding);
            if (pdomBinding instanceof ICPPClassType && name.getParent() instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier && (ownerBinding = this.adaptBinding((ownerNode = (ICPPASTCompositeTypeSpecifier)(baseNode = (ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier)name.getParent()).getParent()).getName().resolveBinding())) != null && ownerBinding instanceof PDOMCPPClassType) {
                PDOMCPPClassType ownerClass = (PDOMCPPClassType)ownerBinding;
                PDOMCPPBase pdomBase = new PDOMCPPBase(this.pdom, (PDOMCPPClassType)pdomBinding, baseNode.isVirtual(), baseNode.getVisibility());
                ownerClass.addBase(pdomBase);
            }
        }
        return pdomBinding;
    }

    protected int getBindingType(IBinding binding) {
        if (binding instanceof ICPPTemplateDefinition) {
            return 0;
        }
        if (binding instanceof ICPPField) {
            return 6;
        }
        if (binding instanceof ICPPVariable) {
            return 3;
        }
        if (binding instanceof ICPPMethod) {
            return 7;
        }
        if (binding instanceof ICPPFunction) {
            return 4;
        }
        if (binding instanceof ICPPClassType) {
            return 5;
        }
        if (binding instanceof ICPPNamespaceAlias) {
            return 9;
        }
        if (binding instanceof ICPPNamespace) {
            return 8;
        }
        if (binding instanceof IEnumeration) {
            return 12;
        }
        if (binding instanceof IEnumerator) {
            return 13;
        }
        if (binding instanceof ITypedef) {
            return 14;
        }
        return 0;
    }

    public PDOMBinding adaptBinding(IBinding binding) throws CoreException {
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        if (binding instanceof PDOMBinding) {
            return (PDOMBinding)binding;
        }
        PDOMNode parent = this.getParent(binding);
        if (parent == this) {
            FindBinding visitor = new FindBinding(this.pdom, binding.getNameCharArray(), this.getBindingType(binding));
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof PDOMMemberOwner) {
            FindBinding2 visitor = new FindBinding2(binding.getNameCharArray(), this.getBindingType(binding));
            PDOMMemberOwner owner = (PDOMMemberOwner)parent;
            try {
                owner.accept(visitor);
            }
            catch (CoreException e) {
                if (e.getStatus().equals(Status.OK_STATUS)) {
                    return visitor.getBinding();
                }
                throw e;
            }
        } else if (parent instanceof PDOMCPPNamespace) {
            FindBinding visitor = new FindBinding(this.pdom, binding.getNameCharArray(), this.getBindingType(binding));
            ((PDOMCPPNamespace)parent).getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    public IBinding resolveBinding(IASTName name) throws CoreException {
        FindBinding visitor;
        IASTNode parent;
        IBinding origBinding = name.getBinding();
        if (origBinding != null) {
            return this.adaptBinding(origBinding);
        }
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] names = ((ICPPASTQualifiedName)name).getNames();
            if (names.length == 1) {
                return this.resolveBinding(names[0]);
            }
            IASTName lastName = names[names.length - 1];
            PDOMBinding nsBinding = this.adaptBinding(names[names.length - 2].resolveBinding());
            if (nsBinding instanceof IScope) {
                return ((IScope)((Object)nsBinding)).getBinding(lastName, true);
            }
        }
        if ((parent = name.getParent()) instanceof ICPPASTQualifiedName) {
            ICPPASTQualifiedName qualName = (ICPPASTQualifiedName)parent;
            IASTName lastName = qualName.getLastName();
            if (name != lastName) {
                return this.resolveInQualifiedName(name);
            }
            parent = parent.getParent();
        }
        if (parent instanceof IASTIdExpression) {
            FindBinding visitor2;
            IASTNode eParent = parent.getParent();
            if (eParent instanceof IASTFunctionCallExpression) {
                visitor2 = new FindBinding(this.pdom, name.toCharArray(), 4);
                this.getIndex().accept(visitor2);
                return visitor2.pdomBinding;
            }
            visitor2 = new FindBinding(this.pdom, name.toCharArray(), name.getParent() instanceof ICPPASTQualifiedName && ((ICPPASTQualifiedName)name.getParent()).getLastName() != name ? 8 : 3);
            this.getIndex().accept(visitor2);
            return visitor2.pdomBinding;
        }
        if (parent instanceof IASTNamedTypeSpecifier) {
            visitor = new FindBinding(this.pdom, name.toCharArray(), 5);
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof ICPPASTNamespaceAlias) {
            visitor = new FindBinding(this.pdom, name.toCharArray(), 8);
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    private PDOMBinding resolveInQualifiedName(IASTName name) throws CoreException {
        ICPPASTQualifiedName qualName = (ICPPASTQualifiedName)name.getParent();
        IASTName[] names = qualName.getNames();
        IASTName nsName = null;
        int i = 0;
        while (i < names.length) {
            if (names[i] == name) break;
            nsName = names[i];
            ++i;
        }
        if (nsName == names[names.length - 1]) {
            return null;
        }
        if (nsName == null) {
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), new int[]{8, 5});
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof ICPPBasicType) {
            return new PDOMCPPBasicType(this.pdom, parent, (ICPPBasicType)type);
        }
        return super.addType(parent, type);
    }

    public PDOMNode getNode(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 3: {
                return new PDOMCPPVariable(this.pdom, record);
            }
            case 4: {
                return new PDOMCPPFunction(this.pdom, record);
            }
            case 5: {
                return new PDOMCPPClassType(this.pdom, record);
            }
            case 6: {
                return new PDOMCPPField(this.pdom, record);
            }
            case 7: {
                return new PDOMCPPMethod(this.pdom, record);
            }
            case 8: {
                return new PDOMCPPNamespace(this.pdom, record);
            }
            case 9: {
                return new PDOMCPPNamespaceAlias(this.pdom, record);
            }
            case 10: {
                return new PDOMCPPBasicType(this.pdom, record);
            }
            case 12: {
                return new PDOMCPPEnumeration(this.pdom, record);
            }
            case 13: {
                return new PDOMCPPEnumerator(this.pdom, record);
            }
            case 14: {
                return new PDOMCPPTypedef(this.pdom, record);
            }
        }
        return super.getNode(record);
    }

    private static final class FindBinding
    extends PDOMNamedNode.NodeFinder {
        PDOMBinding pdomBinding;
        final int[] desiredType;

        public FindBinding(PDOM pdom, char[] name, int desiredType) {
            this(pdom, name, new int[]{desiredType});
        }

        public FindBinding(PDOM pdom, char[] name, int[] desiredType) {
            super(pdom, name);
            this.desiredType = desiredType;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0) {
                return true;
            }
            PDOMBinding tBinding = this.pdom.getBinding(record);
            if (!tBinding.hasName(this.name)) {
                return false;
            }
            int nodeType = tBinding.getNodeType();
            int i = 0;
            while (i < this.desiredType.length) {
                if (nodeType == this.desiredType[i]) {
                    this.pdomBinding = tBinding;
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class FindBinding2
    implements IPDOMVisitor {
        private PDOMBinding binding;
        private final char[] name;
        private final int[] desiredType;

        public FindBinding2(char[] name, int desiredType) {
            this(name, new int[]{desiredType});
        }

        public FindBinding2(char[] name, int[] desiredType) {
            this.name = name;
            this.desiredType = desiredType;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            PDOMBinding tBinding;
            if (node instanceof PDOMBinding && (tBinding = (PDOMBinding)node).hasName(this.name)) {
                int nodeType = tBinding.getNodeType();
                int i = 0;
                while (i < this.desiredType.length) {
                    if (nodeType == this.desiredType[i]) {
                        this.binding = tBinding;
                        throw new CoreException(Status.OK_STATUS);
                    }
                    ++i;
                }
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public PDOMBinding getBinding() {
            return this.binding;
        }
    }
}

