/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPParameter
extends PDOMNamedNode
implements ICPPParameter {
    private static final int NEXT_PARAM = 12;
    private static final int TYPE = 16;
    public static final int RECORD_SIZE = 20;

    public PDOMCPPParameter(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPParameter(PDOM pdom, PDOMNode parent, IASTName name, ICPPParameter param) throws CoreException {
        super(pdom, parent, name.toCharArray());
        Database db = pdom.getDB();
        db.putInt(this.record + 12, 0);
        IType type = param.getType();
        if (type != null) {
            PDOMNode typeNode = this.getLinkage().addType(this, type);
            db.putInt(this.record + 16, typeNode != null ? typeNode.getRecord() : 0);
        }
    }

    protected int getRecordSize() {
        return 20;
    }

    public int getNodeType() {
        return 11;
    }

    public void setNextParameter(PDOMCPPParameter nextParam) throws CoreException {
        int rec = nextParam != null ? nextParam.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, rec);
    }

    public PDOMCPPParameter getNextParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    public IASTInitializer getDefaultValue() {
        return null;
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = this.getLinkage().getNode(this.pdom.getDB().getInt(this.record + 16));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isExtern() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isRegister() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isStatic() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IScope getScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public Object getAdapter(Class adapter) {
        throw new PDOMNotImplementedError();
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }
}

